// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.AttributeMappingSource;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Parse Expression Response.
 */
public class ParseExpressionResponse implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Error.
     * Error details, if expression evaluation resulted in an error.
     */
    @SerializedName(value = "error", alternate = {"Error"})
    @Expose
	@Nullable
    public PublicError error;

    /**
     * The Evaluation Result.
     * A collection of values produced by the evaluation of the expression.
     */
    @SerializedName(value = "evaluationResult", alternate = {"EvaluationResult"})
    @Expose
	@Nullable
    public java.util.List<String> evaluationResult;

    /**
     * The Evaluation Succeeded.
     * true if the evaluation was successful.
     */
    @SerializedName(value = "evaluationSucceeded", alternate = {"EvaluationSucceeded"})
    @Expose
	@Nullable
    public Boolean evaluationSucceeded;

    /**
     * The Parsed Expression.
     * An attributeMappingSource object representing the parsed expression.
     */
    @SerializedName(value = "parsedExpression", alternate = {"ParsedExpression"})
    @Expose
	@Nullable
    public AttributeMappingSource parsedExpression;

    /**
     * The Parsing Succeeded.
     * true if the expression was parsed successfully.
     */
    @SerializedName(value = "parsingSucceeded", alternate = {"ParsingSucceeded"})
    @Expose
	@Nullable
    public Boolean parsingSucceeded;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
