// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.BaseEndUserNotification;
import com.microsoft.graph.models.TrainingReminderNotification;
import com.microsoft.graph.models.EndUserNotificationSetting;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Training Notification Setting.
 */
public class TrainingNotificationSetting extends EndUserNotificationSetting implements IJsonBackedObject {


    /**
     * The Training Assignment.
     * 
     */
    @SerializedName(value = "trainingAssignment", alternate = {"TrainingAssignment"})
    @Expose
	@Nullable
    public BaseEndUserNotification trainingAssignment;

    /**
     * The Training Reminder.
     * 
     */
    @SerializedName(value = "trainingReminder", alternate = {"TrainingReminder"})
    @Expose
	@Nullable
    public TrainingReminderNotification trainingReminder;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
