// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequest;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Request Cancel Request Builder.
 */
public class PrivilegedAccessGroupEligibilityScheduleRequestCancelRequestBuilder extends BaseActionRequestBuilder<PrivilegedAccessGroupEligibilityScheduleRequest> {

    /**
     * The request builder for this PrivilegedAccessGroupEligibilityScheduleRequestCancel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupEligibilityScheduleRequestCancelRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest
     *
     * @param requestOptions the options for the request
     * @return the PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest instance
     */
    @Nonnull
    public PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest instance
     */
    @Nonnull
    public PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest request = new PrivilegedAccessGroupEligibilityScheduleRequestCancelRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
