// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.RiskyServicePrincipalDismissRequest;
import com.microsoft.graph.models.RiskyServicePrincipal;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.RiskyServicePrincipalDismissParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal Dismiss Request Builder.
 */
public class RiskyServicePrincipalDismissRequestBuilder extends BaseActionRequestBuilder<RiskyServicePrincipal> {

    /**
     * The request builder for this RiskyServicePrincipalDismiss
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskyServicePrincipalDismissRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private RiskyServicePrincipalDismissParameterSet body;
    /**
     * The request builder for this RiskyServicePrincipalDismiss
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public RiskyServicePrincipalDismissRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final RiskyServicePrincipalDismissParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the RiskyServicePrincipalDismissRequest
     *
     * @param requestOptions the options for the request
     * @return the RiskyServicePrincipalDismissRequest instance
     */
    @Nonnull
    public RiskyServicePrincipalDismissRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the RiskyServicePrincipalDismissRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the RiskyServicePrincipalDismissRequest instance
     */
    @Nonnull
    public RiskyServicePrincipalDismissRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final RiskyServicePrincipalDismissRequest request = new RiskyServicePrincipalDismissRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
