// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsMalwareInformation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Malware Information Request.
 */
public class WindowsMalwareInformationRequest extends BaseRequest<WindowsMalwareInformation> {
	
    /**
     * The request for the WindowsMalwareInformation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsMalwareInformationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsMalwareInformation.class);
    }

    /**
     * Gets the WindowsMalwareInformation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMalwareInformation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsMalwareInformation from the service
     *
     * @return the WindowsMalwareInformation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMalwareInformation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMalwareInformation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsMalwareInformation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsMalwareInformation with a source
     *
     * @param sourceWindowsMalwareInformation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMalwareInformation> patchAsync(@Nonnull final WindowsMalwareInformation sourceWindowsMalwareInformation) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsMalwareInformation);
    }

    /**
     * Patches this WindowsMalwareInformation with a source
     *
     * @param sourceWindowsMalwareInformation the source object with updates
     * @return the updated WindowsMalwareInformation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMalwareInformation patch(@Nonnull final WindowsMalwareInformation sourceWindowsMalwareInformation) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsMalwareInformation);
    }

    /**
     * Creates a WindowsMalwareInformation with a new object
     *
     * @param newWindowsMalwareInformation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMalwareInformation> postAsync(@Nonnull final WindowsMalwareInformation newWindowsMalwareInformation) {
        return sendAsync(HttpMethod.POST, newWindowsMalwareInformation);
    }

    /**
     * Creates a WindowsMalwareInformation with a new object
     *
     * @param newWindowsMalwareInformation the new object to create
     * @return the created WindowsMalwareInformation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMalwareInformation post(@Nonnull final WindowsMalwareInformation newWindowsMalwareInformation) throws ClientException {
        return send(HttpMethod.POST, newWindowsMalwareInformation);
    }

    /**
     * Creates a WindowsMalwareInformation with a new object
     *
     * @param newWindowsMalwareInformation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMalwareInformation> putAsync(@Nonnull final WindowsMalwareInformation newWindowsMalwareInformation) {
        return sendAsync(HttpMethod.PUT, newWindowsMalwareInformation);
    }

    /**
     * Creates a WindowsMalwareInformation with a new object
     *
     * @param newWindowsMalwareInformation the object to create/update
     * @return the created WindowsMalwareInformation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMalwareInformation put(@Nonnull final WindowsMalwareInformation newWindowsMalwareInformation) throws ClientException {
        return send(HttpMethod.PUT, newWindowsMalwareInformation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMalwareInformationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMalwareInformationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

