// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Subdomain;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subdomain Request.
 */
public class SubdomainRequest extends BaseRequest<Subdomain> {
	
    /**
     * The request for the Subdomain
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubdomainRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Subdomain.class);
    }

    /**
     * Gets the Subdomain from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Subdomain> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Subdomain from the service
     *
     * @return the Subdomain from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Subdomain get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Subdomain> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Subdomain delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Subdomain with a source
     *
     * @param sourceSubdomain the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Subdomain> patchAsync(@Nonnull final Subdomain sourceSubdomain) {
        return sendAsync(HttpMethod.PATCH, sourceSubdomain);
    }

    /**
     * Patches this Subdomain with a source
     *
     * @param sourceSubdomain the source object with updates
     * @return the updated Subdomain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Subdomain patch(@Nonnull final Subdomain sourceSubdomain) throws ClientException {
        return send(HttpMethod.PATCH, sourceSubdomain);
    }

    /**
     * Creates a Subdomain with a new object
     *
     * @param newSubdomain the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Subdomain> postAsync(@Nonnull final Subdomain newSubdomain) {
        return sendAsync(HttpMethod.POST, newSubdomain);
    }

    /**
     * Creates a Subdomain with a new object
     *
     * @param newSubdomain the new object to create
     * @return the created Subdomain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Subdomain post(@Nonnull final Subdomain newSubdomain) throws ClientException {
        return send(HttpMethod.POST, newSubdomain);
    }

    /**
     * Creates a Subdomain with a new object
     *
     * @param newSubdomain the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Subdomain> putAsync(@Nonnull final Subdomain newSubdomain) {
        return sendAsync(HttpMethod.PUT, newSubdomain);
    }

    /**
     * Creates a Subdomain with a new object
     *
     * @param newSubdomain the object to create/update
     * @return the created Subdomain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Subdomain put(@Nonnull final Subdomain newSubdomain) throws ClientException {
        return send(HttpMethod.PUT, newSubdomain);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SubdomainRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SubdomainRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

