/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ListItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ListItemCollectionPage;
import com.microsoft.graph.requests.ListItemCollectionRequestBuilder;
import com.microsoft.graph.requests.ListItemCollectionResponse;
import com.microsoft.graph.requests.ListItemRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListItemCollectionRequest
extends BaseEntityCollectionRequest<ListItem, ListItemCollectionResponse, ListItemCollectionPage> {
    public ListItemCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ListItemCollectionResponse.class, ListItemCollectionPage.class, ListItemCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ListItem> postAsync(@Nonnull ListItem newListItem) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newListItem);
    }

    @Nonnull
    public ListItem post(@Nonnull ListItem newListItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newListItem);
    }

    @Nonnull
    public ListItemCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ListItemCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

