// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.externalconnectors.models.ExternalActivity;
import com.microsoft.graph.externalconnectors.models.ExternalActivityResult;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.externalconnectors.requests.ExternalItemAddActivitiesCollectionRequestBuilder;
import com.microsoft.graph.externalconnectors.requests.ExternalItemAddActivitiesCollectionRequest;
import com.microsoft.graph.externalconnectors.requests.ExternalItemAddActivitiesCollectionResponse;
import com.microsoft.graph.externalconnectors.models.ExternalItemAddActivitiesParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseActionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the External Item Add Activities Collection Request Builder.
 */
public class ExternalItemAddActivitiesCollectionRequestBuilder extends BaseActionCollectionRequestBuilder<ExternalActivityResult, ExternalItemAddActivitiesCollectionRequestBuilder, ExternalItemAddActivitiesCollectionResponse, ExternalItemAddActivitiesCollectionPage, ExternalItemAddActivitiesCollectionRequest> {

    /**
     * The request builder for this collection of ExternalItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExternalItemAddActivitiesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExternalItemAddActivitiesCollectionRequestBuilder.class, ExternalItemAddActivitiesCollectionRequest.class);
    }
    private ExternalItemAddActivitiesParameterSet body;
    /**
     * The request builder for this collection of ExternalItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ExternalItemAddActivitiesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ExternalItemAddActivitiesParameterSet parameters) {
        super(requestUrl, client, requestOptions, ExternalItemAddActivitiesCollectionRequestBuilder.class, ExternalItemAddActivitiesCollectionRequest.class);
        this.body = parameters;
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ExternalItemAddActivitiesCollectionRequest instance
     */
    @Override
    @Nonnull
    public ExternalItemAddActivitiesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ExternalItemAddActivitiesCollectionRequest request = super.buildRequest(requestOptions);
            request.body = this.body;
            return request;
    }
}
