// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Local Credential.
 */
public class DeviceLocalCredential extends Entity implements IJsonBackedObject {


    /**
     * The Account Name.
     * The name of the local admin account for which LAPS is enabled.
     */
    @SerializedName(value = "accountName", alternate = {"AccountName"})
    @Expose
	@Nullable
    public String accountName;

    /**
     * The Account Sid.
     * The SID of the local admin account for which LAPS is enabled.
     */
    @SerializedName(value = "accountSid", alternate = {"AccountSid"})
    @Expose
	@Nullable
    public String accountSid;

    /**
     * The Backup Date Time.
     * When the local administrator account credential for the device object was backed up to Azure Active Directory.
     */
    @SerializedName(value = "backupDateTime", alternate = {"BackupDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime backupDateTime;

    /**
     * The Password Base64.
     * The password for the local administrator account that is backed up to Azure Active Directory and returned as a Base64 encoded value.
     */
    @SerializedName(value = "passwordBase64", alternate = {"PasswordBase64"})
    @Expose
	@Nullable
    public String passwordBase64;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
