// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.VirtualEventRegistrationQuestionAnswer;
import com.microsoft.graph.models.VirtualEventAttendeeRegistrationStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Registration.
 */
public class VirtualEventRegistration extends Entity implements IJsonBackedObject {


    /**
     * The Cancelation Date Time.
     * Date and time when the registrant cancels their registration for the virtual event. Only appears when applicable. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "cancelationDateTime", alternate = {"CancelationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime cancelationDateTime;

    /**
     * The Email.
     * Email address of the registrant.
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The First Name.
     * First name of the registrant.
     */
    @SerializedName(value = "firstName", alternate = {"FirstName"})
    @Expose
	@Nullable
    public String firstName;

    /**
     * The Last Name.
     * Last name of the registrant.
     */
    @SerializedName(value = "lastName", alternate = {"LastName"})
    @Expose
	@Nullable
    public String lastName;

    /**
     * The Registration Date Time.
     * Date and time when the registrant registers for the virtual event. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "registrationDateTime", alternate = {"RegistrationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime registrationDateTime;

    /**
     * The Registration Question Answers.
     * The registrant's answer to the registration questions.
     */
    @SerializedName(value = "registrationQuestionAnswers", alternate = {"RegistrationQuestionAnswers"})
    @Expose
	@Nullable
    public java.util.List<VirtualEventRegistrationQuestionAnswer> registrationQuestionAnswers;

    /**
     * The Status.
     * Registration status of the registrant. Read-only.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public VirtualEventAttendeeRegistrationStatus status;

    /**
     * The User Id.
     * The registrant's ID in Microsoft Entra ID. Only appears when the registrant is registered in Microsoft Entra ID.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
