// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.DriveItemExtractSensitivityLabelsRequest;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ExtractSensitivityLabelsResult;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Extract Sensitivity Labels Request Builder.
 */
public class DriveItemExtractSensitivityLabelsRequestBuilder extends BaseActionRequestBuilder<ExtractSensitivityLabelsResult> {

    /**
     * The request builder for this DriveItemExtractSensitivityLabels
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DriveItemExtractSensitivityLabelsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the DriveItemExtractSensitivityLabelsRequest
     *
     * @param requestOptions the options for the request
     * @return the DriveItemExtractSensitivityLabelsRequest instance
     */
    @Nonnull
    public DriveItemExtractSensitivityLabelsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the DriveItemExtractSensitivityLabelsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the DriveItemExtractSensitivityLabelsRequest instance
     */
    @Nonnull
    public DriveItemExtractSensitivityLabelsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final DriveItemExtractSensitivityLabelsRequest request = new DriveItemExtractSensitivityLabelsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
