// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TenantAppManagementPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tenant App Management Policy Request.
 */
public class TenantAppManagementPolicyRequest extends BaseRequest<TenantAppManagementPolicy> {
	
    /**
     * The request for the TenantAppManagementPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TenantAppManagementPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TenantAppManagementPolicy.class);
    }

    /**
     * Gets the TenantAppManagementPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantAppManagementPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TenantAppManagementPolicy from the service
     *
     * @return the TenantAppManagementPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantAppManagementPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantAppManagementPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TenantAppManagementPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TenantAppManagementPolicy with a source
     *
     * @param sourceTenantAppManagementPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantAppManagementPolicy> patchAsync(@Nonnull final TenantAppManagementPolicy sourceTenantAppManagementPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceTenantAppManagementPolicy);
    }

    /**
     * Patches this TenantAppManagementPolicy with a source
     *
     * @param sourceTenantAppManagementPolicy the source object with updates
     * @return the updated TenantAppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantAppManagementPolicy patch(@Nonnull final TenantAppManagementPolicy sourceTenantAppManagementPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceTenantAppManagementPolicy);
    }

    /**
     * Creates a TenantAppManagementPolicy with a new object
     *
     * @param newTenantAppManagementPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantAppManagementPolicy> postAsync(@Nonnull final TenantAppManagementPolicy newTenantAppManagementPolicy) {
        return sendAsync(HttpMethod.POST, newTenantAppManagementPolicy);
    }

    /**
     * Creates a TenantAppManagementPolicy with a new object
     *
     * @param newTenantAppManagementPolicy the new object to create
     * @return the created TenantAppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantAppManagementPolicy post(@Nonnull final TenantAppManagementPolicy newTenantAppManagementPolicy) throws ClientException {
        return send(HttpMethod.POST, newTenantAppManagementPolicy);
    }

    /**
     * Creates a TenantAppManagementPolicy with a new object
     *
     * @param newTenantAppManagementPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantAppManagementPolicy> putAsync(@Nonnull final TenantAppManagementPolicy newTenantAppManagementPolicy) {
        return sendAsync(HttpMethod.PUT, newTenantAppManagementPolicy);
    }

    /**
     * Creates a TenantAppManagementPolicy with a new object
     *
     * @param newTenantAppManagementPolicy the object to create/update
     * @return the created TenantAppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantAppManagementPolicy put(@Nonnull final TenantAppManagementPolicy newTenantAppManagementPolicy) throws ClientException {
        return send(HttpMethod.PUT, newTenantAppManagementPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TenantAppManagementPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TenantAppManagementPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

