// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsDeviceStartupProcessPerformance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Device Startup Process Performance Request.
 */
public class UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest extends BaseRequest<UserExperienceAnalyticsDeviceStartupProcessPerformance> {
	
    /**
     * The request for the UserExperienceAnalyticsDeviceStartupProcessPerformance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsDeviceStartupProcessPerformance.class);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupProcessPerformance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcessPerformance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupProcessPerformance from the service
     *
     * @return the UserExperienceAnalyticsDeviceStartupProcessPerformance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcessPerformance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcessPerformance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcessPerformance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupProcessPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupProcessPerformance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcessPerformance> patchAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance sourceUserExperienceAnalyticsDeviceStartupProcessPerformance) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupProcessPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupProcessPerformance the source object with updates
     * @return the updated UserExperienceAnalyticsDeviceStartupProcessPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcessPerformance patch(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance sourceUserExperienceAnalyticsDeviceStartupProcessPerformance) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcessPerformance with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcessPerformance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcessPerformance> postAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance newUserExperienceAnalyticsDeviceStartupProcessPerformance) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcessPerformance with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcessPerformance the new object to create
     * @return the created UserExperienceAnalyticsDeviceStartupProcessPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcessPerformance post(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance newUserExperienceAnalyticsDeviceStartupProcessPerformance) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcessPerformance with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcessPerformance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcessPerformance> putAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance newUserExperienceAnalyticsDeviceStartupProcessPerformance) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcessPerformance with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcessPerformance the object to create/update
     * @return the created UserExperienceAnalyticsDeviceStartupProcessPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcessPerformance put(@Nonnull final UserExperienceAnalyticsDeviceStartupProcessPerformance newUserExperienceAnalyticsDeviceStartupProcessPerformance) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupProcessPerformance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

