// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Article;
import com.microsoft.graph.security.models.ArticleIndicator;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.ArticleIndicatorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.ArticleIndicatorCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.ArticleIndicatorCollectionResponse;
import com.microsoft.graph.security.models.ArticleIndicator;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Article Indicator Collection With References Page.
 */
public class ArticleIndicatorCollectionWithReferencesPage extends BaseCollectionPage<ArticleIndicator, ArticleIndicatorCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ArticleIndicator
     *
     * @param response the serialized ArticleIndicatorCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ArticleIndicatorCollectionWithReferencesPage(@Nonnull final ArticleIndicatorCollectionResponse response, @Nullable final ArticleIndicatorCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ArticleIndicator
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ArticleIndicatorCollectionWithReferencesPage(@Nonnull final java.util.List<ArticleIndicator> pageContents, @Nullable final ArticleIndicatorCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
