// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.SslCertificateEntity;
import com.microsoft.graph.security.models.Artifact;
import com.microsoft.graph.security.requests.HostCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ssl Certificate.
 */
public class SslCertificate extends Artifact implements IJsonBackedObject {


    /**
     * The Expiration Date Time.
     * The date and time when a certificate expires. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Fingerprint.
     * A hash of the certificate calculated on the data and signature.
     */
    @SerializedName(value = "fingerprint", alternate = {"Fingerprint"})
    @Expose
	@Nullable
    public String fingerprint;

    /**
     * The First Seen Date Time.
     * The first date and time when this sslCertificate was observed. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "firstSeenDateTime", alternate = {"FirstSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime firstSeenDateTime;

    /**
     * The Issue Date Time.
     * The date and time when a certificate was issued. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "issueDateTime", alternate = {"IssueDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime issueDateTime;

    /**
     * The Issuer.
     * The entity that grants this certificate.
     */
    @SerializedName(value = "issuer", alternate = {"Issuer"})
    @Expose
	@Nullable
    public SslCertificateEntity issuer;

    /**
     * The Last Seen Date Time.
     * The most recent date and time when this sslCertificate was observed. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastSeenDateTime", alternate = {"LastSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSeenDateTime;

    /**
     * The Serial Number.
     * The serial number associated with an SSL certificate.
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The Sha1.
     * A SHA-1 hash of the certificate. Note: This is not the signature.
     */
    @SerializedName(value = "sha1", alternate = {"Sha1"})
    @Expose
	@Nullable
    public String sha1;

    /**
     * The Subject.
     * The person, site, machine, and so on, this certificate is for.
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public SslCertificateEntity subject;

    /**
     * The Related Hosts.
     * The hosts related with this sslCertificate.
     */
	@Nullable
    public com.microsoft.graph.security.requests.HostCollectionPage relatedHosts;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("relatedHosts")) {
            relatedHosts = serializer.deserializeObject(json.get("relatedHosts"), com.microsoft.graph.security.requests.HostCollectionPage.class);
        }
    }
}
