// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Submission Mail Evidence.
 */
public class SubmissionMailEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Network Message Id.
     * 
     */
    @SerializedName(value = "networkMessageId", alternate = {"NetworkMessageId"})
    @Expose
	@Nullable
    public String networkMessageId;

    /**
     * The Recipient.
     * 
     */
    @SerializedName(value = "recipient", alternate = {"Recipient"})
    @Expose
	@Nullable
    public String recipient;

    /**
     * The Report Type.
     * 
     */
    @SerializedName(value = "reportType", alternate = {"ReportType"})
    @Expose
	@Nullable
    public String reportType;

    /**
     * The Sender.
     * 
     */
    @SerializedName(value = "sender", alternate = {"Sender"})
    @Expose
	@Nullable
    public String sender;

    /**
     * The Sender Ip.
     * 
     */
    @SerializedName(value = "senderIp", alternate = {"SenderIp"})
    @Expose
	@Nullable
    public String senderIp;

    /**
     * The Subject.
     * 
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;

    /**
     * The Submission Date Time.
     * 
     */
    @SerializedName(value = "submissionDateTime", alternate = {"SubmissionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime submissionDateTime;

    /**
     * The Submission Id.
     * 
     */
    @SerializedName(value = "submissionId", alternate = {"SubmissionId"})
    @Expose
	@Nullable
    public String submissionId;

    /**
     * The Submitter.
     * 
     */
    @SerializedName(value = "submitter", alternate = {"Submitter"})
    @Expose
	@Nullable
    public String submitter;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
