/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.groups.item.photos.item;

import com.microsoft.graph.groups.item.photos.item.value.ContentRequestBuilder;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProfilePhotoItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ContentRequestBuilder content() {
        return new ContentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public ProfilePhotoItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/photos/{profilePhoto%2Did}{?%24select}", pathParameters);
    }

    public ProfilePhotoItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/photos/{profilePhoto%2Did}{?%24select}", rawUrl);
    }

    @Nullable
    public ProfilePhoto get() {
        return this.get(null);
    }

    @Nullable
    public ProfilePhoto get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (ProfilePhoto)this.requestAdapter.send(requestInfo, errorMapping, ProfilePhoto::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public ProfilePhotoItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ProfilePhotoItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

