/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidRequiredPasswordType;
import com.microsoft.graph.models.DeviceCompliancePolicy;
import com.microsoft.graph.models.DeviceThreatProtectionLevel;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AndroidCompliancePolicy
extends DeviceCompliancePolicy
implements Parsable {
    public AndroidCompliancePolicy() {
        this.setOdataType("#microsoft.graph.androidCompliancePolicy");
    }

    @Nonnull
    public static AndroidCompliancePolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AndroidCompliancePolicy();
    }

    @Nullable
    public Boolean getDeviceThreatProtectionEnabled() {
        return (Boolean)this.backingStore.get("deviceThreatProtectionEnabled");
    }

    @Nullable
    public DeviceThreatProtectionLevel getDeviceThreatProtectionRequiredSecurityLevel() {
        return (DeviceThreatProtectionLevel)((Object)this.backingStore.get("deviceThreatProtectionRequiredSecurityLevel"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deviceThreatProtectionEnabled", n -> this.setDeviceThreatProtectionEnabled(n.getBooleanValue()));
        deserializerMap.put("deviceThreatProtectionRequiredSecurityLevel", n -> this.setDeviceThreatProtectionRequiredSecurityLevel((DeviceThreatProtectionLevel)n.getEnumValue(DeviceThreatProtectionLevel::forValue)));
        deserializerMap.put("minAndroidSecurityPatchLevel", n -> this.setMinAndroidSecurityPatchLevel(n.getStringValue()));
        deserializerMap.put("osMaximumVersion", n -> this.setOsMaximumVersion(n.getStringValue()));
        deserializerMap.put("osMinimumVersion", n -> this.setOsMinimumVersion(n.getStringValue()));
        deserializerMap.put("passwordExpirationDays", n -> this.setPasswordExpirationDays(n.getIntegerValue()));
        deserializerMap.put("passwordMinimumLength", n -> this.setPasswordMinimumLength(n.getIntegerValue()));
        deserializerMap.put("passwordMinutesOfInactivityBeforeLock", n -> this.setPasswordMinutesOfInactivityBeforeLock(n.getIntegerValue()));
        deserializerMap.put("passwordPreviousPasswordBlockCount", n -> this.setPasswordPreviousPasswordBlockCount(n.getIntegerValue()));
        deserializerMap.put("passwordRequired", n -> this.setPasswordRequired(n.getBooleanValue()));
        deserializerMap.put("passwordRequiredType", n -> this.setPasswordRequiredType((AndroidRequiredPasswordType)n.getEnumValue(AndroidRequiredPasswordType::forValue)));
        deserializerMap.put("securityBlockJailbrokenDevices", n -> this.setSecurityBlockJailbrokenDevices(n.getBooleanValue()));
        deserializerMap.put("securityDisableUsbDebugging", n -> this.setSecurityDisableUsbDebugging(n.getBooleanValue()));
        deserializerMap.put("securityPreventInstallAppsFromUnknownSources", n -> this.setSecurityPreventInstallAppsFromUnknownSources(n.getBooleanValue()));
        deserializerMap.put("securityRequireCompanyPortalAppIntegrity", n -> this.setSecurityRequireCompanyPortalAppIntegrity(n.getBooleanValue()));
        deserializerMap.put("securityRequireGooglePlayServices", n -> this.setSecurityRequireGooglePlayServices(n.getBooleanValue()));
        deserializerMap.put("securityRequireSafetyNetAttestationBasicIntegrity", n -> this.setSecurityRequireSafetyNetAttestationBasicIntegrity(n.getBooleanValue()));
        deserializerMap.put("securityRequireSafetyNetAttestationCertifiedDevice", n -> this.setSecurityRequireSafetyNetAttestationCertifiedDevice(n.getBooleanValue()));
        deserializerMap.put("securityRequireUpToDateSecurityProviders", n -> this.setSecurityRequireUpToDateSecurityProviders(n.getBooleanValue()));
        deserializerMap.put("securityRequireVerifyApps", n -> this.setSecurityRequireVerifyApps(n.getBooleanValue()));
        deserializerMap.put("storageRequireEncryption", n -> this.setStorageRequireEncryption(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMinAndroidSecurityPatchLevel() {
        return (String)this.backingStore.get("minAndroidSecurityPatchLevel");
    }

    @Nullable
    public String getOsMaximumVersion() {
        return (String)this.backingStore.get("osMaximumVersion");
    }

    @Nullable
    public String getOsMinimumVersion() {
        return (String)this.backingStore.get("osMinimumVersion");
    }

    @Nullable
    public Integer getPasswordExpirationDays() {
        return (Integer)this.backingStore.get("passwordExpirationDays");
    }

    @Nullable
    public Integer getPasswordMinimumLength() {
        return (Integer)this.backingStore.get("passwordMinimumLength");
    }

    @Nullable
    public Integer getPasswordMinutesOfInactivityBeforeLock() {
        return (Integer)this.backingStore.get("passwordMinutesOfInactivityBeforeLock");
    }

    @Nullable
    public Integer getPasswordPreviousPasswordBlockCount() {
        return (Integer)this.backingStore.get("passwordPreviousPasswordBlockCount");
    }

    @Nullable
    public Boolean getPasswordRequired() {
        return (Boolean)this.backingStore.get("passwordRequired");
    }

    @Nullable
    public AndroidRequiredPasswordType getPasswordRequiredType() {
        return (AndroidRequiredPasswordType)((Object)this.backingStore.get("passwordRequiredType"));
    }

    @Nullable
    public Boolean getSecurityBlockJailbrokenDevices() {
        return (Boolean)this.backingStore.get("securityBlockJailbrokenDevices");
    }

    @Nullable
    public Boolean getSecurityDisableUsbDebugging() {
        return (Boolean)this.backingStore.get("securityDisableUsbDebugging");
    }

    @Nullable
    public Boolean getSecurityPreventInstallAppsFromUnknownSources() {
        return (Boolean)this.backingStore.get("securityPreventInstallAppsFromUnknownSources");
    }

    @Nullable
    public Boolean getSecurityRequireCompanyPortalAppIntegrity() {
        return (Boolean)this.backingStore.get("securityRequireCompanyPortalAppIntegrity");
    }

    @Nullable
    public Boolean getSecurityRequireGooglePlayServices() {
        return (Boolean)this.backingStore.get("securityRequireGooglePlayServices");
    }

    @Nullable
    public Boolean getSecurityRequireSafetyNetAttestationBasicIntegrity() {
        return (Boolean)this.backingStore.get("securityRequireSafetyNetAttestationBasicIntegrity");
    }

    @Nullable
    public Boolean getSecurityRequireSafetyNetAttestationCertifiedDevice() {
        return (Boolean)this.backingStore.get("securityRequireSafetyNetAttestationCertifiedDevice");
    }

    @Nullable
    public Boolean getSecurityRequireUpToDateSecurityProviders() {
        return (Boolean)this.backingStore.get("securityRequireUpToDateSecurityProviders");
    }

    @Nullable
    public Boolean getSecurityRequireVerifyApps() {
        return (Boolean)this.backingStore.get("securityRequireVerifyApps");
    }

    @Nullable
    public Boolean getStorageRequireEncryption() {
        return (Boolean)this.backingStore.get("storageRequireEncryption");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("deviceThreatProtectionEnabled", this.getDeviceThreatProtectionEnabled());
        writer.writeEnumValue("deviceThreatProtectionRequiredSecurityLevel", (Enum)this.getDeviceThreatProtectionRequiredSecurityLevel());
        writer.writeStringValue("minAndroidSecurityPatchLevel", this.getMinAndroidSecurityPatchLevel());
        writer.writeStringValue("osMaximumVersion", this.getOsMaximumVersion());
        writer.writeStringValue("osMinimumVersion", this.getOsMinimumVersion());
        writer.writeIntegerValue("passwordExpirationDays", this.getPasswordExpirationDays());
        writer.writeIntegerValue("passwordMinimumLength", this.getPasswordMinimumLength());
        writer.writeIntegerValue("passwordMinutesOfInactivityBeforeLock", this.getPasswordMinutesOfInactivityBeforeLock());
        writer.writeIntegerValue("passwordPreviousPasswordBlockCount", this.getPasswordPreviousPasswordBlockCount());
        writer.writeBooleanValue("passwordRequired", this.getPasswordRequired());
        writer.writeEnumValue("passwordRequiredType", (Enum)this.getPasswordRequiredType());
        writer.writeBooleanValue("securityBlockJailbrokenDevices", this.getSecurityBlockJailbrokenDevices());
        writer.writeBooleanValue("securityDisableUsbDebugging", this.getSecurityDisableUsbDebugging());
        writer.writeBooleanValue("securityPreventInstallAppsFromUnknownSources", this.getSecurityPreventInstallAppsFromUnknownSources());
        writer.writeBooleanValue("securityRequireCompanyPortalAppIntegrity", this.getSecurityRequireCompanyPortalAppIntegrity());
        writer.writeBooleanValue("securityRequireGooglePlayServices", this.getSecurityRequireGooglePlayServices());
        writer.writeBooleanValue("securityRequireSafetyNetAttestationBasicIntegrity", this.getSecurityRequireSafetyNetAttestationBasicIntegrity());
        writer.writeBooleanValue("securityRequireSafetyNetAttestationCertifiedDevice", this.getSecurityRequireSafetyNetAttestationCertifiedDevice());
        writer.writeBooleanValue("securityRequireUpToDateSecurityProviders", this.getSecurityRequireUpToDateSecurityProviders());
        writer.writeBooleanValue("securityRequireVerifyApps", this.getSecurityRequireVerifyApps());
        writer.writeBooleanValue("storageRequireEncryption", this.getStorageRequireEncryption());
    }

    public void setDeviceThreatProtectionEnabled(@Nullable Boolean value) {
        this.backingStore.set("deviceThreatProtectionEnabled", (Object)value);
    }

    public void setDeviceThreatProtectionRequiredSecurityLevel(@Nullable DeviceThreatProtectionLevel value) {
        this.backingStore.set("deviceThreatProtectionRequiredSecurityLevel", (Object)value);
    }

    public void setMinAndroidSecurityPatchLevel(@Nullable String value) {
        this.backingStore.set("minAndroidSecurityPatchLevel", (Object)value);
    }

    public void setOsMaximumVersion(@Nullable String value) {
        this.backingStore.set("osMaximumVersion", (Object)value);
    }

    public void setOsMinimumVersion(@Nullable String value) {
        this.backingStore.set("osMinimumVersion", (Object)value);
    }

    public void setPasswordExpirationDays(@Nullable Integer value) {
        this.backingStore.set("passwordExpirationDays", (Object)value);
    }

    public void setPasswordMinimumLength(@Nullable Integer value) {
        this.backingStore.set("passwordMinimumLength", (Object)value);
    }

    public void setPasswordMinutesOfInactivityBeforeLock(@Nullable Integer value) {
        this.backingStore.set("passwordMinutesOfInactivityBeforeLock", (Object)value);
    }

    public void setPasswordPreviousPasswordBlockCount(@Nullable Integer value) {
        this.backingStore.set("passwordPreviousPasswordBlockCount", (Object)value);
    }

    public void setPasswordRequired(@Nullable Boolean value) {
        this.backingStore.set("passwordRequired", (Object)value);
    }

    public void setPasswordRequiredType(@Nullable AndroidRequiredPasswordType value) {
        this.backingStore.set("passwordRequiredType", (Object)value);
    }

    public void setSecurityBlockJailbrokenDevices(@Nullable Boolean value) {
        this.backingStore.set("securityBlockJailbrokenDevices", (Object)value);
    }

    public void setSecurityDisableUsbDebugging(@Nullable Boolean value) {
        this.backingStore.set("securityDisableUsbDebugging", (Object)value);
    }

    public void setSecurityPreventInstallAppsFromUnknownSources(@Nullable Boolean value) {
        this.backingStore.set("securityPreventInstallAppsFromUnknownSources", (Object)value);
    }

    public void setSecurityRequireCompanyPortalAppIntegrity(@Nullable Boolean value) {
        this.backingStore.set("securityRequireCompanyPortalAppIntegrity", (Object)value);
    }

    public void setSecurityRequireGooglePlayServices(@Nullable Boolean value) {
        this.backingStore.set("securityRequireGooglePlayServices", (Object)value);
    }

    public void setSecurityRequireSafetyNetAttestationBasicIntegrity(@Nullable Boolean value) {
        this.backingStore.set("securityRequireSafetyNetAttestationBasicIntegrity", (Object)value);
    }

    public void setSecurityRequireSafetyNetAttestationCertifiedDevice(@Nullable Boolean value) {
        this.backingStore.set("securityRequireSafetyNetAttestationCertifiedDevice", (Object)value);
    }

    public void setSecurityRequireUpToDateSecurityProviders(@Nullable Boolean value) {
        this.backingStore.set("securityRequireUpToDateSecurityProviders", (Object)value);
    }

    public void setSecurityRequireVerifyApps(@Nullable Boolean value) {
        this.backingStore.set("securityRequireVerifyApps", (Object)value);
    }

    public void setStorageRequireEncryption(@Nullable Boolean value) {
        this.backingStore.set("storageRequireEncryption", (Object)value);
    }
}

