/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintJobProcessingState;
import com.microsoft.graph.models.UserIdentity;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ArchivedPrintJob
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ArchivedPrintJob() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ArchivedPrintJob createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ArchivedPrintJob();
    }

    @Nullable
    public Boolean getAcquiredByPrinter() {
        return (Boolean)this.backingStore.get("acquiredByPrinter");
    }

    @Nullable
    public OffsetDateTime getAcquiredDateTime() {
        return (OffsetDateTime)this.backingStore.get("acquiredDateTime");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getCompletionDateTime() {
        return (OffsetDateTime)this.backingStore.get("completionDateTime");
    }

    @Nullable
    public Integer getCopiesPrinted() {
        return (Integer)this.backingStore.get("copiesPrinted");
    }

    @Nullable
    public UserIdentity getCreatedBy() {
        return (UserIdentity)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(11);
        deserializerMap.put("acquiredByPrinter", n -> this.setAcquiredByPrinter(n.getBooleanValue()));
        deserializerMap.put("acquiredDateTime", n -> this.setAcquiredDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("completionDateTime", n -> this.setCompletionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("copiesPrinted", n -> this.setCopiesPrinted(n.getIntegerValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((UserIdentity)n.getObjectValue(UserIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("printerId", n -> this.setPrinterId(n.getStringValue()));
        deserializerMap.put("printerName", n -> this.setPrinterName(n.getStringValue()));
        deserializerMap.put("processingState", n -> this.setProcessingState((PrintJobProcessingState)n.getEnumValue(PrintJobProcessingState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPrinterId() {
        return (String)this.backingStore.get("printerId");
    }

    @Nullable
    public String getPrinterName() {
        return (String)this.backingStore.get("printerName");
    }

    @Nullable
    public PrintJobProcessingState getProcessingState() {
        return (PrintJobProcessingState)((Object)this.backingStore.get("processingState"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("acquiredByPrinter", this.getAcquiredByPrinter());
        writer.writeOffsetDateTimeValue("acquiredDateTime", this.getAcquiredDateTime());
        writer.writeOffsetDateTimeValue("completionDateTime", this.getCompletionDateTime());
        writer.writeIntegerValue("copiesPrinted", this.getCopiesPrinted());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("id", this.getId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("printerId", this.getPrinterId());
        writer.writeStringValue("printerName", this.getPrinterName());
        writer.writeEnumValue("processingState", (Enum)this.getProcessingState());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAcquiredByPrinter(@Nullable Boolean value) {
        this.backingStore.set("acquiredByPrinter", (Object)value);
    }

    public void setAcquiredDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("acquiredDateTime", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCompletionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completionDateTime", (Object)value);
    }

    public void setCopiesPrinted(@Nullable Integer value) {
        this.backingStore.set("copiesPrinted", (Object)value);
    }

    public void setCreatedBy(@Nullable UserIdentity value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrinterId(@Nullable String value) {
        this.backingStore.set("printerId", (Object)value);
    }

    public void setPrinterName(@Nullable String value) {
        this.backingStore.set("printerName", (Object)value);
    }

    public void setProcessingState(@Nullable PrintJobProcessingState value) {
        this.backingStore.set("processingState", (Object)value);
    }
}

