/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationExternalSource;
import com.microsoft.graph.models.EducationSchool;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationOrganization
extends Entity
implements Parsable {
    @Nonnull
    public static EducationOrganization createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.educationSchool": {
                    return new EducationSchool();
                }
            }
        }
        return new EducationOrganization();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public EducationExternalSource getExternalSource() {
        return (EducationExternalSource)((Object)this.backingStore.get("externalSource"));
    }

    @Nullable
    public String getExternalSourceDetail() {
        return (String)this.backingStore.get("externalSourceDetail");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("externalSource", n -> this.setExternalSource((EducationExternalSource)n.getEnumValue(EducationExternalSource::forValue)));
        deserializerMap.put("externalSourceDetail", n -> this.setExternalSourceDetail(n.getStringValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("externalSource", (Enum)this.getExternalSource());
        writer.writeStringValue("externalSourceDetail", this.getExternalSourceDetail());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExternalSource(@Nullable EducationExternalSource value) {
        this.backingStore.set("externalSource", (Object)value);
    }

    public void setExternalSourceDetail(@Nullable String value) {
        this.backingStore.set("externalSourceDetail", (Object)value);
    }
}

