/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAndroidLobApp;
import com.microsoft.graph.models.ManagedAndroidStoreApp;
import com.microsoft.graph.models.ManagedAppAvailability;
import com.microsoft.graph.models.ManagedIOSLobApp;
import com.microsoft.graph.models.ManagedIOSStoreApp;
import com.microsoft.graph.models.ManagedMobileLobApp;
import com.microsoft.graph.models.MobileApp;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedApp
extends MobileApp
implements Parsable {
    public ManagedApp() {
        this.setOdataType("#microsoft.graph.managedApp");
    }

    @Nonnull
    public static ManagedApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.managedAndroidLobApp": {
                    return new ManagedAndroidLobApp();
                }
                case "#microsoft.graph.managedAndroidStoreApp": {
                    return new ManagedAndroidStoreApp();
                }
                case "#microsoft.graph.managedIOSLobApp": {
                    return new ManagedIOSLobApp();
                }
                case "#microsoft.graph.managedIOSStoreApp": {
                    return new ManagedIOSStoreApp();
                }
                case "#microsoft.graph.managedMobileLobApp": {
                    return new ManagedMobileLobApp();
                }
            }
        }
        return new ManagedApp();
    }

    @Nullable
    public ManagedAppAvailability getAppAvailability() {
        return (ManagedAppAvailability)((Object)this.backingStore.get("appAvailability"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appAvailability", n -> this.setAppAvailability((ManagedAppAvailability)n.getEnumValue(ManagedAppAvailability::forValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getVersion() {
        return (String)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("appAvailability", (Enum)this.getAppAvailability());
        writer.writeStringValue("version", this.getVersion());
    }

    public void setAppAvailability(@Nullable ManagedAppAvailability value) {
        this.backingStore.set("appAvailability", (Object)value);
    }

    public void setVersion(@Nullable String value) {
        this.backingStore.set("version", (Object)value);
    }
}

