/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttendeeAvailability;
import com.microsoft.graph.models.FreeBusyStatus;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.TimeSlot;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MeetingTimeSuggestion
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MeetingTimeSuggestion() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MeetingTimeSuggestion createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MeetingTimeSuggestion();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<AttendeeAvailability> getAttendeeAvailability() {
        return (List)this.backingStore.get("attendeeAvailability");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Double getConfidence() {
        return (Double)this.backingStore.get("confidence");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("attendeeAvailability", n -> this.setAttendeeAvailability(n.getCollectionOfObjectValues(AttendeeAvailability::createFromDiscriminatorValue)));
        deserializerMap.put("confidence", n -> this.setConfidence(n.getDoubleValue()));
        deserializerMap.put("locations", n -> this.setLocations(n.getCollectionOfObjectValues(Location::createFromDiscriminatorValue)));
        deserializerMap.put("meetingTimeSlot", n -> this.setMeetingTimeSlot((TimeSlot)n.getObjectValue(TimeSlot::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("order", n -> this.setOrder(n.getIntegerValue()));
        deserializerMap.put("organizerAvailability", n -> this.setOrganizerAvailability((FreeBusyStatus)n.getEnumValue(FreeBusyStatus::forValue)));
        deserializerMap.put("suggestionReason", n -> this.setSuggestionReason(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<Location> getLocations() {
        return (List)this.backingStore.get("locations");
    }

    @Nullable
    public TimeSlot getMeetingTimeSlot() {
        return (TimeSlot)this.backingStore.get("meetingTimeSlot");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getOrder() {
        return (Integer)this.backingStore.get("order");
    }

    @Nullable
    public FreeBusyStatus getOrganizerAvailability() {
        return (FreeBusyStatus)((Object)this.backingStore.get("organizerAvailability"));
    }

    @Nullable
    public String getSuggestionReason() {
        return (String)this.backingStore.get("suggestionReason");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("attendeeAvailability", this.getAttendeeAvailability());
        writer.writeDoubleValue("confidence", this.getConfidence());
        writer.writeCollectionOfObjectValues("locations", this.getLocations());
        writer.writeObjectValue("meetingTimeSlot", (Parsable)this.getMeetingTimeSlot(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("order", this.getOrder());
        writer.writeEnumValue("organizerAvailability", (Enum)this.getOrganizerAvailability());
        writer.writeStringValue("suggestionReason", this.getSuggestionReason());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAttendeeAvailability(@Nullable List<AttendeeAvailability> value) {
        this.backingStore.set("attendeeAvailability", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConfidence(@Nullable Double value) {
        this.backingStore.set("confidence", (Object)value);
    }

    public void setLocations(@Nullable List<Location> value) {
        this.backingStore.set("locations", value);
    }

    public void setMeetingTimeSlot(@Nullable TimeSlot value) {
        this.backingStore.set("meetingTimeSlot", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrder(@Nullable Integer value) {
        this.backingStore.set("order", (Object)value);
    }

    public void setOrganizerAvailability(@Nullable FreeBusyStatus value) {
        this.backingStore.set("organizerAvailability", (Object)value);
    }

    public void setSuggestionReason(@Nullable String value) {
        this.backingStore.set("suggestionReason", (Object)value);
    }
}

