/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.StoragePlanInformation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Quota
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Quota() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Quota createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Quota();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getDeleted() {
        return (Long)this.backingStore.get("deleted");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("deleted", n -> this.setDeleted(n.getLongValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("remaining", n -> this.setRemaining(n.getLongValue()));
        deserializerMap.put("state", n -> this.setState(n.getStringValue()));
        deserializerMap.put("storagePlanInformation", n -> this.setStoragePlanInformation((StoragePlanInformation)n.getObjectValue(StoragePlanInformation::createFromDiscriminatorValue)));
        deserializerMap.put("total", n -> this.setTotal(n.getLongValue()));
        deserializerMap.put("used", n -> this.setUsed(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Long getRemaining() {
        return (Long)this.backingStore.get("remaining");
    }

    @Nullable
    public String getState() {
        return (String)this.backingStore.get("state");
    }

    @Nullable
    public StoragePlanInformation getStoragePlanInformation() {
        return (StoragePlanInformation)this.backingStore.get("storagePlanInformation");
    }

    @Nullable
    public Long getTotal() {
        return (Long)this.backingStore.get("total");
    }

    @Nullable
    public Long getUsed() {
        return (Long)this.backingStore.get("used");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeLongValue("deleted", this.getDeleted());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLongValue("remaining", this.getRemaining());
        writer.writeStringValue("state", this.getState());
        writer.writeObjectValue("storagePlanInformation", (Parsable)this.getStoragePlanInformation(), new Parsable[0]);
        writer.writeLongValue("total", this.getTotal());
        writer.writeLongValue("used", this.getUsed());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDeleted(@Nullable Long value) {
        this.backingStore.set("deleted", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRemaining(@Nullable Long value) {
        this.backingStore.set("remaining", (Object)value);
    }

    public void setState(@Nullable String value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setStoragePlanInformation(@Nullable StoragePlanInformation value) {
        this.backingStore.set("storagePlanInformation", (Object)value);
    }

    public void setTotal(@Nullable Long value) {
        this.backingStore.set("total", (Object)value);
    }

    public void setUsed(@Nullable Long value) {
        this.backingStore.set("used", (Object)value);
    }
}

