/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.Alert;
import com.microsoft.graph.models.security.AlertClassification;
import com.microsoft.graph.models.security.AlertComment;
import com.microsoft.graph.models.security.AlertDetermination;
import com.microsoft.graph.models.security.AlertSeverity;
import com.microsoft.graph.models.security.IncidentStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Incident
extends Entity
implements Parsable {
    @Nonnull
    public static Incident createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Incident();
    }

    @Nullable
    public List<Alert> getAlerts() {
        return (List)this.backingStore.get("alerts");
    }

    @Nullable
    public String getAssignedTo() {
        return (String)this.backingStore.get("assignedTo");
    }

    @Nullable
    public AlertClassification getClassification() {
        return (AlertClassification)((Object)this.backingStore.get("classification"));
    }

    @Nullable
    public List<AlertComment> getComments() {
        return (List)this.backingStore.get("comments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<String> getCustomTags() {
        return (List)this.backingStore.get("customTags");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public AlertDetermination getDetermination() {
        return (AlertDetermination)((Object)this.backingStore.get("determination"));
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("alerts", n -> this.setAlerts(n.getCollectionOfObjectValues(Alert::createFromDiscriminatorValue)));
        deserializerMap.put("assignedTo", n -> this.setAssignedTo(n.getStringValue()));
        deserializerMap.put("classification", n -> this.setClassification((AlertClassification)n.getEnumValue(AlertClassification::forValue)));
        deserializerMap.put("comments", n -> this.setComments(n.getCollectionOfObjectValues(AlertComment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customTags", n -> this.setCustomTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("determination", n -> this.setDetermination((AlertDetermination)n.getEnumValue(AlertDetermination::forValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("incidentWebUrl", n -> this.setIncidentWebUrl(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy(n.getStringValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("redirectIncidentId", n -> this.setRedirectIncidentId(n.getStringValue()));
        deserializerMap.put("severity", n -> this.setSeverity((AlertSeverity)n.getEnumValue(AlertSeverity::forValue)));
        deserializerMap.put("status", n -> this.setStatus((IncidentStatus)n.getEnumValue(IncidentStatus::forValue)));
        deserializerMap.put("systemTags", n -> this.setSystemTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIncidentWebUrl() {
        return (String)this.backingStore.get("incidentWebUrl");
    }

    @Nullable
    public String getLastModifiedBy() {
        return (String)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public String getRedirectIncidentId() {
        return (String)this.backingStore.get("redirectIncidentId");
    }

    @Nullable
    public AlertSeverity getSeverity() {
        return (AlertSeverity)((Object)this.backingStore.get("severity"));
    }

    @Nullable
    public IncidentStatus getStatus() {
        return (IncidentStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public List<String> getSystemTags() {
        return (List)this.backingStore.get("systemTags");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("alerts", this.getAlerts());
        writer.writeStringValue("assignedTo", this.getAssignedTo());
        writer.writeEnumValue("classification", (Enum)this.getClassification());
        writer.writeCollectionOfObjectValues("comments", this.getComments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfPrimitiveValues("customTags", this.getCustomTags());
        writer.writeStringValue("description", this.getDescription());
        writer.writeEnumValue("determination", (Enum)this.getDetermination());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("incidentWebUrl", this.getIncidentWebUrl());
        writer.writeStringValue("lastModifiedBy", this.getLastModifiedBy());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeStringValue("redirectIncidentId", this.getRedirectIncidentId());
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeCollectionOfPrimitiveValues("systemTags", this.getSystemTags());
        writer.writeStringValue("tenantId", this.getTenantId());
    }

    public void setAlerts(@Nullable List<Alert> value) {
        this.backingStore.set("alerts", value);
    }

    public void setAssignedTo(@Nullable String value) {
        this.backingStore.set("assignedTo", (Object)value);
    }

    public void setClassification(@Nullable AlertClassification value) {
        this.backingStore.set("classification", (Object)value);
    }

    public void setComments(@Nullable List<AlertComment> value) {
        this.backingStore.set("comments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomTags(@Nullable List<String> value) {
        this.backingStore.set("customTags", value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDetermination(@Nullable AlertDetermination value) {
        this.backingStore.set("determination", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIncidentWebUrl(@Nullable String value) {
        this.backingStore.set("incidentWebUrl", (Object)value);
    }

    public void setLastModifiedBy(@Nullable String value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setRedirectIncidentId(@Nullable String value) {
        this.backingStore.set("redirectIncidentId", (Object)value);
    }

    public void setSeverity(@Nullable AlertSeverity value) {
        this.backingStore.set("severity", (Object)value);
    }

    public void setStatus(@Nullable IncidentStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setSystemTags(@Nullable List<String> value) {
        this.backingStore.set("systemTags", value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }
}

