/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.termstore;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.termstore.Set;
import com.microsoft.graph.models.termstore.TermGroupScope;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Group
extends Entity
implements Parsable {
    @Nonnull
    public static Group createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Group();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("parentSiteId", n -> this.setParentSiteId(n.getStringValue()));
        deserializerMap.put("scope", n -> this.setScope((TermGroupScope)n.getEnumValue(TermGroupScope::forValue)));
        deserializerMap.put("sets", n -> this.setSets(n.getCollectionOfObjectValues(Set::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getParentSiteId() {
        return (String)this.backingStore.get("parentSiteId");
    }

    @Nullable
    public TermGroupScope getScope() {
        return (TermGroupScope)((Object)this.backingStore.get("scope"));
    }

    @Nullable
    public List<Set> getSets() {
        return (List)this.backingStore.get("sets");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("parentSiteId", this.getParentSiteId());
        writer.writeEnumValue("scope", (Enum)this.getScope());
        writer.writeCollectionOfObjectValues("sets", this.getSets());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setParentSiteId(@Nullable String value) {
        this.backingStore.set("parentSiteId", (Object)value);
    }

    public void setScope(@Nullable TermGroupScope value) {
        this.backingStore.set("scope", (Object)value);
    }

    public void setSets(@Nullable List<Set> value) {
        this.backingStore.set("sets", value);
    }
}

