/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.organization.item.branding.squarelogo;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SquareLogoRequestBuilder
extends BaseRequestBuilder {
    public SquareLogoRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/organization/{organization%2Did}/branding/squareLogo", pathParameters);
    }

    public SquareLogoRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/organization/{organization%2Did}/branding/squareLogo", rawUrl);
    }

    @Nullable
    public InputStream get() {
        return this.get(null);
    }

    @Nullable
    public InputStream get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (InputStream)this.requestAdapter.sendPrimitive(requestInfo, errorMapping, InputStream.class);
    }

    @Nullable
    public InputStream put(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.put(body, contentType, null);
    }

    @Nullable
    public InputStream put(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = this.toPutRequestInformation(body, contentType, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (InputStream)this.requestAdapter.sendPrimitive(requestInfo, errorMapping, InputStream.class);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "image/bmp, image/jpg, image/jpeg, image/gif, image/vnd.microsoft.icon, image/png, image/tiff, application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.toPutRequestInformation(body, contentType, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setStreamContent(body, contentType);
        return requestInfo;
    }

    @Nonnull
    public SquareLogoRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new SquareLogoRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

