/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationConditions;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.OnTokenIssuanceStartListener;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AuthenticationEventListener
extends Entity
implements Parsable {
    @Nonnull
    public static AuthenticationEventListener createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.onTokenIssuanceStartListener": {
                    return new OnTokenIssuanceStartListener();
                }
            }
        }
        return new AuthenticationEventListener();
    }

    @Nullable
    public String getAuthenticationEventsFlowId() {
        return (String)this.backingStore.get("authenticationEventsFlowId");
    }

    @Nullable
    public AuthenticationConditions getConditions() {
        return (AuthenticationConditions)this.backingStore.get("conditions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("authenticationEventsFlowId", n -> this.setAuthenticationEventsFlowId(n.getStringValue()));
        deserializerMap.put("conditions", n -> this.setConditions((AuthenticationConditions)n.getObjectValue(AuthenticationConditions::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("authenticationEventsFlowId", this.getAuthenticationEventsFlowId());
        writer.writeObjectValue("conditions", (Parsable)this.getConditions(), new Parsable[0]);
    }

    public void setAuthenticationEventsFlowId(@Nullable String value) {
        this.backingStore.set("authenticationEventsFlowId", (Object)value);
    }

    public void setConditions(@Nullable AuthenticationConditions value) {
        this.backingStore.set("conditions", (Object)value);
    }
}

