/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AgreementAcceptance;
import com.microsoft.graph.models.AgreementFile;
import com.microsoft.graph.models.AgreementFileLocalization;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.TermsExpiration;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Agreement
extends Entity
implements Parsable {
    @Nonnull
    public static Agreement createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Agreement();
    }

    @Nullable
    public List<AgreementAcceptance> getAcceptances() {
        return (List)this.backingStore.get("acceptances");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("acceptances", n -> this.setAcceptances(n.getCollectionOfObjectValues(AgreementAcceptance::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("file", n -> this.setFile((AgreementFile)n.getObjectValue(AgreementFile::createFromDiscriminatorValue)));
        deserializerMap.put("files", n -> this.setFiles(n.getCollectionOfObjectValues(AgreementFileLocalization::createFromDiscriminatorValue)));
        deserializerMap.put("isPerDeviceAcceptanceRequired", n -> this.setIsPerDeviceAcceptanceRequired(n.getBooleanValue()));
        deserializerMap.put("isViewingBeforeAcceptanceRequired", n -> this.setIsViewingBeforeAcceptanceRequired(n.getBooleanValue()));
        deserializerMap.put("termsExpiration", n -> this.setTermsExpiration((TermsExpiration)n.getObjectValue(TermsExpiration::createFromDiscriminatorValue)));
        deserializerMap.put("userReacceptRequiredFrequency", n -> this.setUserReacceptRequiredFrequency(n.getPeriodAndDurationValue()));
        return deserializerMap;
    }

    @Nullable
    public AgreementFile getFile() {
        return (AgreementFile)this.backingStore.get("file");
    }

    @Nullable
    public List<AgreementFileLocalization> getFiles() {
        return (List)this.backingStore.get("files");
    }

    @Nullable
    public Boolean getIsPerDeviceAcceptanceRequired() {
        return (Boolean)this.backingStore.get("isPerDeviceAcceptanceRequired");
    }

    @Nullable
    public Boolean getIsViewingBeforeAcceptanceRequired() {
        return (Boolean)this.backingStore.get("isViewingBeforeAcceptanceRequired");
    }

    @Nullable
    public TermsExpiration getTermsExpiration() {
        return (TermsExpiration)this.backingStore.get("termsExpiration");
    }

    @Nullable
    public PeriodAndDuration getUserReacceptRequiredFrequency() {
        return (PeriodAndDuration)this.backingStore.get("userReacceptRequiredFrequency");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("acceptances", this.getAcceptances());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("file", (Parsable)this.getFile(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("files", this.getFiles());
        writer.writeBooleanValue("isPerDeviceAcceptanceRequired", this.getIsPerDeviceAcceptanceRequired());
        writer.writeBooleanValue("isViewingBeforeAcceptanceRequired", this.getIsViewingBeforeAcceptanceRequired());
        writer.writeObjectValue("termsExpiration", (Parsable)this.getTermsExpiration(), new Parsable[0]);
        writer.writePeriodAndDurationValue("userReacceptRequiredFrequency", this.getUserReacceptRequiredFrequency());
    }

    public void setAcceptances(@Nullable List<AgreementAcceptance> value) {
        this.backingStore.set("acceptances", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setFile(@Nullable AgreementFile value) {
        this.backingStore.set("file", (Object)value);
    }

    public void setFiles(@Nullable List<AgreementFileLocalization> value) {
        this.backingStore.set("files", value);
    }

    public void setIsPerDeviceAcceptanceRequired(@Nullable Boolean value) {
        this.backingStore.set("isPerDeviceAcceptanceRequired", (Object)value);
    }

    public void setIsViewingBeforeAcceptanceRequired(@Nullable Boolean value) {
        this.backingStore.set("isViewingBeforeAcceptanceRequired", (Object)value);
    }

    public void setTermsExpiration(@Nullable TermsExpiration value) {
        this.backingStore.set("termsExpiration", (Object)value);
    }

    public void setUserReacceptRequiredFrequency(@Nullable PeriodAndDuration value) {
        this.backingStore.set("userReacceptRequiredFrequency", (Object)value);
    }
}

