/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AlertDetection;
import com.microsoft.graph.models.AlertFeedback;
import com.microsoft.graph.models.AlertHistoryState;
import com.microsoft.graph.models.AlertSeverity;
import com.microsoft.graph.models.AlertStatus;
import com.microsoft.graph.models.AlertTrigger;
import com.microsoft.graph.models.CloudAppSecurityState;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.FileSecurityState;
import com.microsoft.graph.models.HostSecurityState;
import com.microsoft.graph.models.InvestigationSecurityState;
import com.microsoft.graph.models.MalwareState;
import com.microsoft.graph.models.MessageSecurityState;
import com.microsoft.graph.models.NetworkConnection;
import com.microsoft.graph.models.Process;
import com.microsoft.graph.models.RegistryKeyState;
import com.microsoft.graph.models.SecurityResource;
import com.microsoft.graph.models.SecurityVendorInformation;
import com.microsoft.graph.models.UriClickSecurityState;
import com.microsoft.graph.models.UserSecurityState;
import com.microsoft.graph.models.VulnerabilityState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Alert
extends Entity
implements Parsable {
    @Nonnull
    public static Alert createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Alert();
    }

    @Nullable
    public String getActivityGroupName() {
        return (String)this.backingStore.get("activityGroupName");
    }

    @Nullable
    public List<AlertDetection> getAlertDetections() {
        return (List)this.backingStore.get("alertDetections");
    }

    @Nullable
    public String getAssignedTo() {
        return (String)this.backingStore.get("assignedTo");
    }

    @Nullable
    public String getAzureSubscriptionId() {
        return (String)this.backingStore.get("azureSubscriptionId");
    }

    @Nullable
    public String getAzureTenantId() {
        return (String)this.backingStore.get("azureTenantId");
    }

    @Nullable
    public String getCategory() {
        return (String)this.backingStore.get("category");
    }

    @Nullable
    public OffsetDateTime getClosedDateTime() {
        return (OffsetDateTime)this.backingStore.get("closedDateTime");
    }

    @Nullable
    public List<CloudAppSecurityState> getCloudAppStates() {
        return (List)this.backingStore.get("cloudAppStates");
    }

    @Nullable
    public List<String> getComments() {
        return (List)this.backingStore.get("comments");
    }

    @Nullable
    public Integer getConfidence() {
        return (Integer)this.backingStore.get("confidence");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public List<String> getDetectionIds() {
        return (List)this.backingStore.get("detectionIds");
    }

    @Nullable
    public OffsetDateTime getEventDateTime() {
        return (OffsetDateTime)this.backingStore.get("eventDateTime");
    }

    @Nullable
    public AlertFeedback getFeedback() {
        return (AlertFeedback)((Object)this.backingStore.get("feedback"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activityGroupName", n -> this.setActivityGroupName(n.getStringValue()));
        deserializerMap.put("alertDetections", n -> this.setAlertDetections(n.getCollectionOfObjectValues(AlertDetection::createFromDiscriminatorValue)));
        deserializerMap.put("assignedTo", n -> this.setAssignedTo(n.getStringValue()));
        deserializerMap.put("azureSubscriptionId", n -> this.setAzureSubscriptionId(n.getStringValue()));
        deserializerMap.put("azureTenantId", n -> this.setAzureTenantId(n.getStringValue()));
        deserializerMap.put("category", n -> this.setCategory(n.getStringValue()));
        deserializerMap.put("closedDateTime", n -> this.setClosedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("cloudAppStates", n -> this.setCloudAppStates(n.getCollectionOfObjectValues(CloudAppSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("comments", n -> this.setComments(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("confidence", n -> this.setConfidence(n.getIntegerValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("detectionIds", n -> this.setDetectionIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("eventDateTime", n -> this.setEventDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("feedback", n -> this.setFeedback((AlertFeedback)n.getEnumValue(AlertFeedback::forValue)));
        deserializerMap.put("fileStates", n -> this.setFileStates(n.getCollectionOfObjectValues(FileSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("historyStates", n -> this.setHistoryStates(n.getCollectionOfObjectValues(AlertHistoryState::createFromDiscriminatorValue)));
        deserializerMap.put("hostStates", n -> this.setHostStates(n.getCollectionOfObjectValues(HostSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("incidentIds", n -> this.setIncidentIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("investigationSecurityStates", n -> this.setInvestigationSecurityStates(n.getCollectionOfObjectValues(InvestigationSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("lastEventDateTime", n -> this.setLastEventDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("malwareStates", n -> this.setMalwareStates(n.getCollectionOfObjectValues(MalwareState::createFromDiscriminatorValue)));
        deserializerMap.put("messageSecurityStates", n -> this.setMessageSecurityStates(n.getCollectionOfObjectValues(MessageSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("networkConnections", n -> this.setNetworkConnections(n.getCollectionOfObjectValues(NetworkConnection::createFromDiscriminatorValue)));
        deserializerMap.put("processes", n -> this.setProcesses(n.getCollectionOfObjectValues(Process::createFromDiscriminatorValue)));
        deserializerMap.put("recommendedActions", n -> this.setRecommendedActions(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("registryKeyStates", n -> this.setRegistryKeyStates(n.getCollectionOfObjectValues(RegistryKeyState::createFromDiscriminatorValue)));
        deserializerMap.put("securityResources", n -> this.setSecurityResources(n.getCollectionOfObjectValues(SecurityResource::createFromDiscriminatorValue)));
        deserializerMap.put("severity", n -> this.setSeverity((AlertSeverity)n.getEnumValue(AlertSeverity::forValue)));
        deserializerMap.put("sourceMaterials", n -> this.setSourceMaterials(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("status", n -> this.setStatus((AlertStatus)n.getEnumValue(AlertStatus::forValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        deserializerMap.put("triggers", n -> this.setTriggers(n.getCollectionOfObjectValues(AlertTrigger::createFromDiscriminatorValue)));
        deserializerMap.put("uriClickSecurityStates", n -> this.setUriClickSecurityStates(n.getCollectionOfObjectValues(UriClickSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("userStates", n -> this.setUserStates(n.getCollectionOfObjectValues(UserSecurityState::createFromDiscriminatorValue)));
        deserializerMap.put("vendorInformation", n -> this.setVendorInformation((SecurityVendorInformation)n.getObjectValue(SecurityVendorInformation::createFromDiscriminatorValue)));
        deserializerMap.put("vulnerabilityStates", n -> this.setVulnerabilityStates(n.getCollectionOfObjectValues(VulnerabilityState::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<FileSecurityState> getFileStates() {
        return (List)this.backingStore.get("fileStates");
    }

    @Nullable
    public List<AlertHistoryState> getHistoryStates() {
        return (List)this.backingStore.get("historyStates");
    }

    @Nullable
    public List<HostSecurityState> getHostStates() {
        return (List)this.backingStore.get("hostStates");
    }

    @Nullable
    public List<String> getIncidentIds() {
        return (List)this.backingStore.get("incidentIds");
    }

    @Nullable
    public List<InvestigationSecurityState> getInvestigationSecurityStates() {
        return (List)this.backingStore.get("investigationSecurityStates");
    }

    @Nullable
    public OffsetDateTime getLastEventDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastEventDateTime");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<MalwareState> getMalwareStates() {
        return (List)this.backingStore.get("malwareStates");
    }

    @Nullable
    public List<MessageSecurityState> getMessageSecurityStates() {
        return (List)this.backingStore.get("messageSecurityStates");
    }

    @Nullable
    public List<NetworkConnection> getNetworkConnections() {
        return (List)this.backingStore.get("networkConnections");
    }

    @Nullable
    public List<Process> getProcesses() {
        return (List)this.backingStore.get("processes");
    }

    @Nullable
    public List<String> getRecommendedActions() {
        return (List)this.backingStore.get("recommendedActions");
    }

    @Nullable
    public List<RegistryKeyState> getRegistryKeyStates() {
        return (List)this.backingStore.get("registryKeyStates");
    }

    @Nullable
    public List<SecurityResource> getSecurityResources() {
        return (List)this.backingStore.get("securityResources");
    }

    @Nullable
    public AlertSeverity getSeverity() {
        return (AlertSeverity)((Object)this.backingStore.get("severity"));
    }

    @Nullable
    public List<String> getSourceMaterials() {
        return (List)this.backingStore.get("sourceMaterials");
    }

    @Nullable
    public AlertStatus getStatus() {
        return (AlertStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public List<String> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Nullable
    public List<AlertTrigger> getTriggers() {
        return (List)this.backingStore.get("triggers");
    }

    @Nullable
    public List<UriClickSecurityState> getUriClickSecurityStates() {
        return (List)this.backingStore.get("uriClickSecurityStates");
    }

    @Nullable
    public List<UserSecurityState> getUserStates() {
        return (List)this.backingStore.get("userStates");
    }

    @Nullable
    public SecurityVendorInformation getVendorInformation() {
        return (SecurityVendorInformation)this.backingStore.get("vendorInformation");
    }

    @Nullable
    public List<VulnerabilityState> getVulnerabilityStates() {
        return (List)this.backingStore.get("vulnerabilityStates");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("activityGroupName", this.getActivityGroupName());
        writer.writeCollectionOfObjectValues("alertDetections", this.getAlertDetections());
        writer.writeStringValue("assignedTo", this.getAssignedTo());
        writer.writeStringValue("azureSubscriptionId", this.getAzureSubscriptionId());
        writer.writeStringValue("azureTenantId", this.getAzureTenantId());
        writer.writeStringValue("category", this.getCategory());
        writer.writeOffsetDateTimeValue("closedDateTime", this.getClosedDateTime());
        writer.writeCollectionOfObjectValues("cloudAppStates", this.getCloudAppStates());
        writer.writeCollectionOfPrimitiveValues("comments", this.getComments());
        writer.writeIntegerValue("confidence", this.getConfidence());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfPrimitiveValues("detectionIds", this.getDetectionIds());
        writer.writeOffsetDateTimeValue("eventDateTime", this.getEventDateTime());
        writer.writeEnumValue("feedback", (Enum)this.getFeedback());
        writer.writeCollectionOfObjectValues("fileStates", this.getFileStates());
        writer.writeCollectionOfObjectValues("historyStates", this.getHistoryStates());
        writer.writeCollectionOfObjectValues("hostStates", this.getHostStates());
        writer.writeCollectionOfPrimitiveValues("incidentIds", this.getIncidentIds());
        writer.writeCollectionOfObjectValues("investigationSecurityStates", this.getInvestigationSecurityStates());
        writer.writeOffsetDateTimeValue("lastEventDateTime", this.getLastEventDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("malwareStates", this.getMalwareStates());
        writer.writeCollectionOfObjectValues("messageSecurityStates", this.getMessageSecurityStates());
        writer.writeCollectionOfObjectValues("networkConnections", this.getNetworkConnections());
        writer.writeCollectionOfObjectValues("processes", this.getProcesses());
        writer.writeCollectionOfPrimitiveValues("recommendedActions", this.getRecommendedActions());
        writer.writeCollectionOfObjectValues("registryKeyStates", this.getRegistryKeyStates());
        writer.writeCollectionOfObjectValues("securityResources", this.getSecurityResources());
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
        writer.writeCollectionOfPrimitiveValues("sourceMaterials", this.getSourceMaterials());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeCollectionOfPrimitiveValues("tags", this.getTags());
        writer.writeStringValue("title", this.getTitle());
        writer.writeCollectionOfObjectValues("triggers", this.getTriggers());
        writer.writeCollectionOfObjectValues("uriClickSecurityStates", this.getUriClickSecurityStates());
        writer.writeCollectionOfObjectValues("userStates", this.getUserStates());
        writer.writeObjectValue("vendorInformation", (Parsable)this.getVendorInformation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("vulnerabilityStates", this.getVulnerabilityStates());
    }

    public void setActivityGroupName(@Nullable String value) {
        this.backingStore.set("activityGroupName", (Object)value);
    }

    public void setAlertDetections(@Nullable List<AlertDetection> value) {
        this.backingStore.set("alertDetections", value);
    }

    public void setAssignedTo(@Nullable String value) {
        this.backingStore.set("assignedTo", (Object)value);
    }

    public void setAzureSubscriptionId(@Nullable String value) {
        this.backingStore.set("azureSubscriptionId", (Object)value);
    }

    public void setAzureTenantId(@Nullable String value) {
        this.backingStore.set("azureTenantId", (Object)value);
    }

    public void setCategory(@Nullable String value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setClosedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("closedDateTime", (Object)value);
    }

    public void setCloudAppStates(@Nullable List<CloudAppSecurityState> value) {
        this.backingStore.set("cloudAppStates", value);
    }

    public void setComments(@Nullable List<String> value) {
        this.backingStore.set("comments", value);
    }

    public void setConfidence(@Nullable Integer value) {
        this.backingStore.set("confidence", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDetectionIds(@Nullable List<String> value) {
        this.backingStore.set("detectionIds", value);
    }

    public void setEventDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("eventDateTime", (Object)value);
    }

    public void setFeedback(@Nullable AlertFeedback value) {
        this.backingStore.set("feedback", (Object)value);
    }

    public void setFileStates(@Nullable List<FileSecurityState> value) {
        this.backingStore.set("fileStates", value);
    }

    public void setHistoryStates(@Nullable List<AlertHistoryState> value) {
        this.backingStore.set("historyStates", value);
    }

    public void setHostStates(@Nullable List<HostSecurityState> value) {
        this.backingStore.set("hostStates", value);
    }

    public void setIncidentIds(@Nullable List<String> value) {
        this.backingStore.set("incidentIds", value);
    }

    public void setInvestigationSecurityStates(@Nullable List<InvestigationSecurityState> value) {
        this.backingStore.set("investigationSecurityStates", value);
    }

    public void setLastEventDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastEventDateTime", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setMalwareStates(@Nullable List<MalwareState> value) {
        this.backingStore.set("malwareStates", value);
    }

    public void setMessageSecurityStates(@Nullable List<MessageSecurityState> value) {
        this.backingStore.set("messageSecurityStates", value);
    }

    public void setNetworkConnections(@Nullable List<NetworkConnection> value) {
        this.backingStore.set("networkConnections", value);
    }

    public void setProcesses(@Nullable List<Process> value) {
        this.backingStore.set("processes", value);
    }

    public void setRecommendedActions(@Nullable List<String> value) {
        this.backingStore.set("recommendedActions", value);
    }

    public void setRegistryKeyStates(@Nullable List<RegistryKeyState> value) {
        this.backingStore.set("registryKeyStates", value);
    }

    public void setSecurityResources(@Nullable List<SecurityResource> value) {
        this.backingStore.set("securityResources", value);
    }

    public void setSeverity(@Nullable AlertSeverity value) {
        this.backingStore.set("severity", (Object)value);
    }

    public void setSourceMaterials(@Nullable List<String> value) {
        this.backingStore.set("sourceMaterials", value);
    }

    public void setStatus(@Nullable AlertStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setTags(@Nullable List<String> value) {
        this.backingStore.set("tags", value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }

    public void setTriggers(@Nullable List<AlertTrigger> value) {
        this.backingStore.set("triggers", value);
    }

    public void setUriClickSecurityStates(@Nullable List<UriClickSecurityState> value) {
        this.backingStore.set("uriClickSecurityStates", value);
    }

    public void setUserStates(@Nullable List<UserSecurityState> value) {
        this.backingStore.set("userStates", value);
    }

    public void setVendorInformation(@Nullable SecurityVendorInformation value) {
        this.backingStore.set("vendorInformation", (Object)value);
    }

    public void setVulnerabilityStates(@Nullable List<VulnerabilityState> value) {
        this.backingStore.set("vulnerabilityStates", value);
    }
}

