/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationCombinationConfiguration;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.AuthenticationStrengthPolicyType;
import com.microsoft.graph.models.AuthenticationStrengthRequirements;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AuthenticationStrengthPolicy
extends Entity
implements Parsable {
    @Nonnull
    public static AuthenticationStrengthPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AuthenticationStrengthPolicy();
    }

    @Nullable
    public List<AuthenticationMethodModes> getAllowedCombinations() {
        return (List)this.backingStore.get("allowedCombinations");
    }

    @Nullable
    public List<AuthenticationCombinationConfiguration> getCombinationConfigurations() {
        return (List)this.backingStore.get("combinationConfigurations");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedCombinations", n -> this.setAllowedCombinations(n.getCollectionOfEnumValues(AuthenticationMethodModes::forValue)));
        deserializerMap.put("combinationConfigurations", n -> this.setCombinationConfigurations(n.getCollectionOfObjectValues(AuthenticationCombinationConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("policyType", n -> this.setPolicyType((AuthenticationStrengthPolicyType)n.getEnumValue(AuthenticationStrengthPolicyType::forValue)));
        deserializerMap.put("requirementsSatisfied", n -> this.setRequirementsSatisfied(n.getEnumSetValue(AuthenticationStrengthRequirements::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public AuthenticationStrengthPolicyType getPolicyType() {
        return (AuthenticationStrengthPolicyType)((Object)this.backingStore.get("policyType"));
    }

    @Nullable
    public EnumSet<AuthenticationStrengthRequirements> getRequirementsSatisfied() {
        return (EnumSet)this.backingStore.get("requirementsSatisfied");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfEnumValues("allowedCombinations", this.getAllowedCombinations());
        writer.writeCollectionOfObjectValues("combinationConfigurations", this.getCombinationConfigurations());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeEnumValue("policyType", (Enum)this.getPolicyType());
        writer.writeEnumSetValue("requirementsSatisfied", this.getRequirementsSatisfied());
    }

    public void setAllowedCombinations(@Nullable List<AuthenticationMethodModes> value) {
        this.backingStore.set("allowedCombinations", value);
    }

    public void setCombinationConfigurations(@Nullable List<AuthenticationCombinationConfiguration> value) {
        this.backingStore.set("combinationConfigurations", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setPolicyType(@Nullable AuthenticationStrengthPolicyType value) {
        this.backingStore.set("policyType", (Object)value);
    }

    public void setRequirementsSatisfied(@Nullable EnumSet<AuthenticationStrengthRequirements> value) {
        this.backingStore.set("requirementsSatisfied", value);
    }
}

