/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingsAvailability;
import com.microsoft.graph.models.BookingsAvailabilityWindow;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingSchedulingPolicy
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public BookingSchedulingPolicy() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static BookingSchedulingPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingSchedulingPolicy();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowStaffSelection() {
        return (Boolean)this.backingStore.get("allowStaffSelection");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<BookingsAvailabilityWindow> getCustomAvailabilities() {
        return (List)this.backingStore.get("customAvailabilities");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("allowStaffSelection", n -> this.setAllowStaffSelection(n.getBooleanValue()));
        deserializerMap.put("customAvailabilities", n -> this.setCustomAvailabilities(n.getCollectionOfObjectValues(BookingsAvailabilityWindow::createFromDiscriminatorValue)));
        deserializerMap.put("generalAvailability", n -> this.setGeneralAvailability((BookingsAvailability)n.getObjectValue(BookingsAvailability::createFromDiscriminatorValue)));
        deserializerMap.put("isMeetingInviteToCustomersEnabled", n -> this.setIsMeetingInviteToCustomersEnabled(n.getBooleanValue()));
        deserializerMap.put("maximumAdvance", n -> this.setMaximumAdvance(n.getPeriodAndDurationValue()));
        deserializerMap.put("minimumLeadTime", n -> this.setMinimumLeadTime(n.getPeriodAndDurationValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("sendConfirmationsToOwner", n -> this.setSendConfirmationsToOwner(n.getBooleanValue()));
        deserializerMap.put("timeSlotInterval", n -> this.setTimeSlotInterval(n.getPeriodAndDurationValue()));
        return deserializerMap;
    }

    @Nullable
    public BookingsAvailability getGeneralAvailability() {
        return (BookingsAvailability)this.backingStore.get("generalAvailability");
    }

    @Nullable
    public Boolean getIsMeetingInviteToCustomersEnabled() {
        return (Boolean)this.backingStore.get("isMeetingInviteToCustomersEnabled");
    }

    @Nullable
    public PeriodAndDuration getMaximumAdvance() {
        return (PeriodAndDuration)this.backingStore.get("maximumAdvance");
    }

    @Nullable
    public PeriodAndDuration getMinimumLeadTime() {
        return (PeriodAndDuration)this.backingStore.get("minimumLeadTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getSendConfirmationsToOwner() {
        return (Boolean)this.backingStore.get("sendConfirmationsToOwner");
    }

    @Nullable
    public PeriodAndDuration getTimeSlotInterval() {
        return (PeriodAndDuration)this.backingStore.get("timeSlotInterval");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowStaffSelection", this.getAllowStaffSelection());
        writer.writeCollectionOfObjectValues("customAvailabilities", this.getCustomAvailabilities());
        writer.writeObjectValue("generalAvailability", (Parsable)this.getGeneralAvailability(), new Parsable[0]);
        writer.writeBooleanValue("isMeetingInviteToCustomersEnabled", this.getIsMeetingInviteToCustomersEnabled());
        writer.writePeriodAndDurationValue("maximumAdvance", this.getMaximumAdvance());
        writer.writePeriodAndDurationValue("minimumLeadTime", this.getMinimumLeadTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("sendConfirmationsToOwner", this.getSendConfirmationsToOwner());
        writer.writePeriodAndDurationValue("timeSlotInterval", this.getTimeSlotInterval());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowStaffSelection(@Nullable Boolean value) {
        this.backingStore.set("allowStaffSelection", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCustomAvailabilities(@Nullable List<BookingsAvailabilityWindow> value) {
        this.backingStore.set("customAvailabilities", value);
    }

    public void setGeneralAvailability(@Nullable BookingsAvailability value) {
        this.backingStore.set("generalAvailability", (Object)value);
    }

    public void setIsMeetingInviteToCustomersEnabled(@Nullable Boolean value) {
        this.backingStore.set("isMeetingInviteToCustomersEnabled", (Object)value);
    }

    public void setMaximumAdvance(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maximumAdvance", (Object)value);
    }

    public void setMinimumLeadTime(@Nullable PeriodAndDuration value) {
        this.backingStore.set("minimumLeadTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSendConfirmationsToOwner(@Nullable Boolean value) {
        this.backingStore.set("sendConfirmationsToOwner", (Object)value);
    }

    public void setTimeSlotInterval(@Nullable PeriodAndDuration value) {
        this.backingStore.set("timeSlotInterval", (Object)value);
    }
}

