/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CertificateAuthority
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public CertificateAuthority() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static CertificateAuthority createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CertificateAuthority();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public byte[] getCertificate() {
        return (byte[])this.backingStore.get("certificate");
    }

    @Nullable
    public String getCertificateRevocationListUrl() {
        return (String)this.backingStore.get("certificateRevocationListUrl");
    }

    @Nullable
    public String getDeltaCertificateRevocationListUrl() {
        return (String)this.backingStore.get("deltaCertificateRevocationListUrl");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("certificate", n -> this.setCertificate(n.getByteArrayValue()));
        deserializerMap.put("certificateRevocationListUrl", n -> this.setCertificateRevocationListUrl(n.getStringValue()));
        deserializerMap.put("deltaCertificateRevocationListUrl", n -> this.setDeltaCertificateRevocationListUrl(n.getStringValue()));
        deserializerMap.put("isRootAuthority", n -> this.setIsRootAuthority(n.getBooleanValue()));
        deserializerMap.put("issuer", n -> this.setIssuer(n.getStringValue()));
        deserializerMap.put("issuerSki", n -> this.setIssuerSki(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsRootAuthority() {
        return (Boolean)this.backingStore.get("isRootAuthority");
    }

    @Nullable
    public String getIssuer() {
        return (String)this.backingStore.get("issuer");
    }

    @Nullable
    public String getIssuerSki() {
        return (String)this.backingStore.get("issuerSki");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeByteArrayValue("certificate", this.getCertificate());
        writer.writeStringValue("certificateRevocationListUrl", this.getCertificateRevocationListUrl());
        writer.writeStringValue("deltaCertificateRevocationListUrl", this.getDeltaCertificateRevocationListUrl());
        writer.writeBooleanValue("isRootAuthority", this.getIsRootAuthority());
        writer.writeStringValue("issuer", this.getIssuer());
        writer.writeStringValue("issuerSki", this.getIssuerSki());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCertificate(@Nullable byte[] value) {
        this.backingStore.set("certificate", (Object)value);
    }

    public void setCertificateRevocationListUrl(@Nullable String value) {
        this.backingStore.set("certificateRevocationListUrl", (Object)value);
    }

    public void setDeltaCertificateRevocationListUrl(@Nullable String value) {
        this.backingStore.set("deltaCertificateRevocationListUrl", (Object)value);
    }

    public void setIsRootAuthority(@Nullable Boolean value) {
        this.backingStore.set("isRootAuthority", (Object)value);
    }

    public void setIssuer(@Nullable String value) {
        this.backingStore.set("issuer", (Object)value);
    }

    public void setIssuerSki(@Nullable String value) {
        this.backingStore.set("issuerSki", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

