/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.RiskDetection;
import com.microsoft.graph.models.RiskyServicePrincipal;
import com.microsoft.graph.models.RiskyUser;
import com.microsoft.graph.models.ServicePrincipalRiskDetection;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IdentityProtectionRoot
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public IdentityProtectionRoot() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static IdentityProtectionRoot createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IdentityProtectionRoot();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("riskDetections", n -> this.setRiskDetections(n.getCollectionOfObjectValues(RiskDetection::createFromDiscriminatorValue)));
        deserializerMap.put("riskyServicePrincipals", n -> this.setRiskyServicePrincipals(n.getCollectionOfObjectValues(RiskyServicePrincipal::createFromDiscriminatorValue)));
        deserializerMap.put("riskyUsers", n -> this.setRiskyUsers(n.getCollectionOfObjectValues(RiskyUser::createFromDiscriminatorValue)));
        deserializerMap.put("servicePrincipalRiskDetections", n -> this.setServicePrincipalRiskDetections(n.getCollectionOfObjectValues(ServicePrincipalRiskDetection::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<RiskDetection> getRiskDetections() {
        return (List)this.backingStore.get("riskDetections");
    }

    @Nullable
    public List<RiskyServicePrincipal> getRiskyServicePrincipals() {
        return (List)this.backingStore.get("riskyServicePrincipals");
    }

    @Nullable
    public List<RiskyUser> getRiskyUsers() {
        return (List)this.backingStore.get("riskyUsers");
    }

    @Nullable
    public List<ServicePrincipalRiskDetection> getServicePrincipalRiskDetections() {
        return (List)this.backingStore.get("servicePrincipalRiskDetections");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("riskDetections", this.getRiskDetections());
        writer.writeCollectionOfObjectValues("riskyServicePrincipals", this.getRiskyServicePrincipals());
        writer.writeCollectionOfObjectValues("riskyUsers", this.getRiskyUsers());
        writer.writeCollectionOfObjectValues("servicePrincipalRiskDetections", this.getServicePrincipalRiskDetections());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRiskDetections(@Nullable List<RiskDetection> value) {
        this.backingStore.set("riskDetections", value);
    }

    public void setRiskyServicePrincipals(@Nullable List<RiskyServicePrincipal> value) {
        this.backingStore.set("riskyServicePrincipals", value);
    }

    public void setRiskyUsers(@Nullable List<RiskyUser> value) {
        this.backingStore.set("riskyUsers", value);
    }

    public void setServicePrincipalRiskDetections(@Nullable List<ServicePrincipalRiskDetection> value) {
        this.backingStore.set("servicePrincipalRiskDetections", value);
    }
}

