/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAppDataEncryptionType;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.graph.models.TargetedManagedAppProtection;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IosManagedAppProtection
extends TargetedManagedAppProtection
implements Parsable {
    public IosManagedAppProtection() {
        this.setOdataType("#microsoft.graph.iosManagedAppProtection");
    }

    @Nonnull
    public static IosManagedAppProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IosManagedAppProtection();
    }

    @Nullable
    public ManagedAppDataEncryptionType getAppDataEncryptionType() {
        return (ManagedAppDataEncryptionType)((Object)this.backingStore.get("appDataEncryptionType"));
    }

    @Nullable
    public List<ManagedMobileApp> getApps() {
        return (List)this.backingStore.get("apps");
    }

    @Nullable
    public String getCustomBrowserProtocol() {
        return (String)this.backingStore.get("customBrowserProtocol");
    }

    @Nullable
    public Integer getDeployedAppCount() {
        return (Integer)this.backingStore.get("deployedAppCount");
    }

    @Nullable
    public ManagedAppPolicyDeploymentSummary getDeploymentSummary() {
        return (ManagedAppPolicyDeploymentSummary)this.backingStore.get("deploymentSummary");
    }

    @Nullable
    public Boolean getFaceIdBlocked() {
        return (Boolean)this.backingStore.get("faceIdBlocked");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appDataEncryptionType", n -> this.setAppDataEncryptionType((ManagedAppDataEncryptionType)n.getEnumValue(ManagedAppDataEncryptionType::forValue)));
        deserializerMap.put("apps", n -> this.setApps(n.getCollectionOfObjectValues(ManagedMobileApp::createFromDiscriminatorValue)));
        deserializerMap.put("customBrowserProtocol", n -> this.setCustomBrowserProtocol(n.getStringValue()));
        deserializerMap.put("deployedAppCount", n -> this.setDeployedAppCount(n.getIntegerValue()));
        deserializerMap.put("deploymentSummary", n -> this.setDeploymentSummary((ManagedAppPolicyDeploymentSummary)n.getObjectValue(ManagedAppPolicyDeploymentSummary::createFromDiscriminatorValue)));
        deserializerMap.put("faceIdBlocked", n -> this.setFaceIdBlocked(n.getBooleanValue()));
        deserializerMap.put("minimumRequiredSdkVersion", n -> this.setMinimumRequiredSdkVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMinimumRequiredSdkVersion() {
        return (String)this.backingStore.get("minimumRequiredSdkVersion");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("appDataEncryptionType", (Enum)this.getAppDataEncryptionType());
        writer.writeCollectionOfObjectValues("apps", this.getApps());
        writer.writeStringValue("customBrowserProtocol", this.getCustomBrowserProtocol());
        writer.writeIntegerValue("deployedAppCount", this.getDeployedAppCount());
        writer.writeObjectValue("deploymentSummary", (Parsable)this.getDeploymentSummary(), new Parsable[0]);
        writer.writeBooleanValue("faceIdBlocked", this.getFaceIdBlocked());
        writer.writeStringValue("minimumRequiredSdkVersion", this.getMinimumRequiredSdkVersion());
    }

    public void setAppDataEncryptionType(@Nullable ManagedAppDataEncryptionType value) {
        this.backingStore.set("appDataEncryptionType", (Object)value);
    }

    public void setApps(@Nullable List<ManagedMobileApp> value) {
        this.backingStore.set("apps", value);
    }

    public void setCustomBrowserProtocol(@Nullable String value) {
        this.backingStore.set("customBrowserProtocol", (Object)value);
    }

    public void setDeployedAppCount(@Nullable Integer value) {
        this.backingStore.set("deployedAppCount", (Object)value);
    }

    public void setDeploymentSummary(@Nullable ManagedAppPolicyDeploymentSummary value) {
        this.backingStore.set("deploymentSummary", (Object)value);
    }

    public void setFaceIdBlocked(@Nullable Boolean value) {
        this.backingStore.set("faceIdBlocked", (Object)value);
    }

    public void setMinimumRequiredSdkVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredSdkVersion", (Object)value);
    }
}

