/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IntegerRange;
import com.microsoft.graph.models.PrintColorMode;
import com.microsoft.graph.models.PrintDuplexMode;
import com.microsoft.graph.models.PrintFinishing;
import com.microsoft.graph.models.PrintMultipageLayout;
import com.microsoft.graph.models.PrintOrientation;
import com.microsoft.graph.models.PrintQuality;
import com.microsoft.graph.models.PrintScaling;
import com.microsoft.graph.models.PrinterFeedOrientation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrinterCapabilities
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PrinterCapabilities() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PrinterCapabilities createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrinterCapabilities();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<Integer> getBottomMargins() {
        return (List)this.backingStore.get("bottomMargins");
    }

    @Nullable
    public Boolean getCollation() {
        return (Boolean)this.backingStore.get("collation");
    }

    @Nullable
    public List<PrintColorMode> getColorModes() {
        return (List)this.backingStore.get("colorModes");
    }

    @Nullable
    public List<String> getContentTypes() {
        return (List)this.backingStore.get("contentTypes");
    }

    @Nullable
    public IntegerRange getCopiesPerJob() {
        return (IntegerRange)this.backingStore.get("copiesPerJob");
    }

    @Nullable
    public List<Integer> getDpis() {
        return (List)this.backingStore.get("dpis");
    }

    @Nullable
    public List<PrintDuplexMode> getDuplexModes() {
        return (List)this.backingStore.get("duplexModes");
    }

    @Nullable
    public List<PrinterFeedOrientation> getFeedOrientations() {
        return (List)this.backingStore.get("feedOrientations");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(26);
        deserializerMap.put("bottomMargins", n -> this.setBottomMargins(n.getCollectionOfPrimitiveValues(Integer.class)));
        deserializerMap.put("collation", n -> this.setCollation(n.getBooleanValue()));
        deserializerMap.put("colorModes", n -> this.setColorModes(n.getCollectionOfEnumValues(PrintColorMode::forValue)));
        deserializerMap.put("contentTypes", n -> this.setContentTypes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("copiesPerJob", n -> this.setCopiesPerJob((IntegerRange)n.getObjectValue(IntegerRange::createFromDiscriminatorValue)));
        deserializerMap.put("dpis", n -> this.setDpis(n.getCollectionOfPrimitiveValues(Integer.class)));
        deserializerMap.put("duplexModes", n -> this.setDuplexModes(n.getCollectionOfEnumValues(PrintDuplexMode::forValue)));
        deserializerMap.put("feedOrientations", n -> this.setFeedOrientations(n.getCollectionOfEnumValues(PrinterFeedOrientation::forValue)));
        deserializerMap.put("finishings", n -> this.setFinishings(n.getCollectionOfEnumValues(PrintFinishing::forValue)));
        deserializerMap.put("inputBins", n -> this.setInputBins(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isColorPrintingSupported", n -> this.setIsColorPrintingSupported(n.getBooleanValue()));
        deserializerMap.put("isPageRangeSupported", n -> this.setIsPageRangeSupported(n.getBooleanValue()));
        deserializerMap.put("leftMargins", n -> this.setLeftMargins(n.getCollectionOfPrimitiveValues(Integer.class)));
        deserializerMap.put("mediaColors", n -> this.setMediaColors(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("mediaSizes", n -> this.setMediaSizes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("mediaTypes", n -> this.setMediaTypes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("multipageLayouts", n -> this.setMultipageLayouts(n.getCollectionOfEnumValues(PrintMultipageLayout::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("orientations", n -> this.setOrientations(n.getCollectionOfEnumValues(PrintOrientation::forValue)));
        deserializerMap.put("outputBins", n -> this.setOutputBins(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("pagesPerSheet", n -> this.setPagesPerSheet(n.getCollectionOfPrimitiveValues(Integer.class)));
        deserializerMap.put("qualities", n -> this.setQualities(n.getCollectionOfEnumValues(PrintQuality::forValue)));
        deserializerMap.put("rightMargins", n -> this.setRightMargins(n.getCollectionOfPrimitiveValues(Integer.class)));
        deserializerMap.put("scalings", n -> this.setScalings(n.getCollectionOfEnumValues(PrintScaling::forValue)));
        deserializerMap.put("supportsFitPdfToPage", n -> this.setSupportsFitPdfToPage(n.getBooleanValue()));
        deserializerMap.put("topMargins", n -> this.setTopMargins(n.getCollectionOfPrimitiveValues(Integer.class)));
        return deserializerMap;
    }

    @Nullable
    public List<PrintFinishing> getFinishings() {
        return (List)this.backingStore.get("finishings");
    }

    @Nullable
    public List<String> getInputBins() {
        return (List)this.backingStore.get("inputBins");
    }

    @Nullable
    public Boolean getIsColorPrintingSupported() {
        return (Boolean)this.backingStore.get("isColorPrintingSupported");
    }

    @Nullable
    public Boolean getIsPageRangeSupported() {
        return (Boolean)this.backingStore.get("isPageRangeSupported");
    }

    @Nullable
    public List<Integer> getLeftMargins() {
        return (List)this.backingStore.get("leftMargins");
    }

    @Nullable
    public List<String> getMediaColors() {
        return (List)this.backingStore.get("mediaColors");
    }

    @Nullable
    public List<String> getMediaSizes() {
        return (List)this.backingStore.get("mediaSizes");
    }

    @Nullable
    public List<String> getMediaTypes() {
        return (List)this.backingStore.get("mediaTypes");
    }

    @Nullable
    public List<PrintMultipageLayout> getMultipageLayouts() {
        return (List)this.backingStore.get("multipageLayouts");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<PrintOrientation> getOrientations() {
        return (List)this.backingStore.get("orientations");
    }

    @Nullable
    public List<String> getOutputBins() {
        return (List)this.backingStore.get("outputBins");
    }

    @Nullable
    public List<Integer> getPagesPerSheet() {
        return (List)this.backingStore.get("pagesPerSheet");
    }

    @Nullable
    public List<PrintQuality> getQualities() {
        return (List)this.backingStore.get("qualities");
    }

    @Nullable
    public List<Integer> getRightMargins() {
        return (List)this.backingStore.get("rightMargins");
    }

    @Nullable
    public List<PrintScaling> getScalings() {
        return (List)this.backingStore.get("scalings");
    }

    @Nullable
    public Boolean getSupportsFitPdfToPage() {
        return (Boolean)this.backingStore.get("supportsFitPdfToPage");
    }

    @Nullable
    public List<Integer> getTopMargins() {
        return (List)this.backingStore.get("topMargins");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("bottomMargins", this.getBottomMargins());
        writer.writeBooleanValue("collation", this.getCollation());
        writer.writeCollectionOfEnumValues("colorModes", this.getColorModes());
        writer.writeCollectionOfPrimitiveValues("contentTypes", this.getContentTypes());
        writer.writeObjectValue("copiesPerJob", (Parsable)this.getCopiesPerJob(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("dpis", this.getDpis());
        writer.writeCollectionOfEnumValues("duplexModes", this.getDuplexModes());
        writer.writeCollectionOfEnumValues("feedOrientations", this.getFeedOrientations());
        writer.writeCollectionOfEnumValues("finishings", this.getFinishings());
        writer.writeCollectionOfPrimitiveValues("inputBins", this.getInputBins());
        writer.writeBooleanValue("isColorPrintingSupported", this.getIsColorPrintingSupported());
        writer.writeBooleanValue("isPageRangeSupported", this.getIsPageRangeSupported());
        writer.writeCollectionOfPrimitiveValues("leftMargins", this.getLeftMargins());
        writer.writeCollectionOfPrimitiveValues("mediaColors", this.getMediaColors());
        writer.writeCollectionOfPrimitiveValues("mediaSizes", this.getMediaSizes());
        writer.writeCollectionOfPrimitiveValues("mediaTypes", this.getMediaTypes());
        writer.writeCollectionOfEnumValues("multipageLayouts", this.getMultipageLayouts());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfEnumValues("orientations", this.getOrientations());
        writer.writeCollectionOfPrimitiveValues("outputBins", this.getOutputBins());
        writer.writeCollectionOfPrimitiveValues("pagesPerSheet", this.getPagesPerSheet());
        writer.writeCollectionOfEnumValues("qualities", this.getQualities());
        writer.writeCollectionOfPrimitiveValues("rightMargins", this.getRightMargins());
        writer.writeCollectionOfEnumValues("scalings", this.getScalings());
        writer.writeBooleanValue("supportsFitPdfToPage", this.getSupportsFitPdfToPage());
        writer.writeCollectionOfPrimitiveValues("topMargins", this.getTopMargins());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBottomMargins(@Nullable List<Integer> value) {
        this.backingStore.set("bottomMargins", value);
    }

    public void setCollation(@Nullable Boolean value) {
        this.backingStore.set("collation", (Object)value);
    }

    public void setColorModes(@Nullable List<PrintColorMode> value) {
        this.backingStore.set("colorModes", value);
    }

    public void setContentTypes(@Nullable List<String> value) {
        this.backingStore.set("contentTypes", value);
    }

    public void setCopiesPerJob(@Nullable IntegerRange value) {
        this.backingStore.set("copiesPerJob", (Object)value);
    }

    public void setDpis(@Nullable List<Integer> value) {
        this.backingStore.set("dpis", value);
    }

    public void setDuplexModes(@Nullable List<PrintDuplexMode> value) {
        this.backingStore.set("duplexModes", value);
    }

    public void setFeedOrientations(@Nullable List<PrinterFeedOrientation> value) {
        this.backingStore.set("feedOrientations", value);
    }

    public void setFinishings(@Nullable List<PrintFinishing> value) {
        this.backingStore.set("finishings", value);
    }

    public void setInputBins(@Nullable List<String> value) {
        this.backingStore.set("inputBins", value);
    }

    public void setIsColorPrintingSupported(@Nullable Boolean value) {
        this.backingStore.set("isColorPrintingSupported", (Object)value);
    }

    public void setIsPageRangeSupported(@Nullable Boolean value) {
        this.backingStore.set("isPageRangeSupported", (Object)value);
    }

    public void setLeftMargins(@Nullable List<Integer> value) {
        this.backingStore.set("leftMargins", value);
    }

    public void setMediaColors(@Nullable List<String> value) {
        this.backingStore.set("mediaColors", value);
    }

    public void setMediaSizes(@Nullable List<String> value) {
        this.backingStore.set("mediaSizes", value);
    }

    public void setMediaTypes(@Nullable List<String> value) {
        this.backingStore.set("mediaTypes", value);
    }

    public void setMultipageLayouts(@Nullable List<PrintMultipageLayout> value) {
        this.backingStore.set("multipageLayouts", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrientations(@Nullable List<PrintOrientation> value) {
        this.backingStore.set("orientations", value);
    }

    public void setOutputBins(@Nullable List<String> value) {
        this.backingStore.set("outputBins", value);
    }

    public void setPagesPerSheet(@Nullable List<Integer> value) {
        this.backingStore.set("pagesPerSheet", value);
    }

    public void setQualities(@Nullable List<PrintQuality> value) {
        this.backingStore.set("qualities", value);
    }

    public void setRightMargins(@Nullable List<Integer> value) {
        this.backingStore.set("rightMargins", value);
    }

    public void setScalings(@Nullable List<PrintScaling> value) {
        this.backingStore.set("scalings", value);
    }

    public void setSupportsFitPdfToPage(@Nullable Boolean value) {
        this.backingStore.set("supportsFitPdfToPage", (Object)value);
    }

    public void setTopMargins(@Nullable List<Integer> value) {
        this.backingStore.set("topMargins", value);
    }
}

