/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.FreeBusyStatus;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ScheduleItem
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ScheduleItem() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ScheduleItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ScheduleItem();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public DateTimeTimeZone getEnd() {
        return (DateTimeTimeZone)this.backingStore.get("end");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("end", n -> this.setEnd((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("isPrivate", n -> this.setIsPrivate(n.getBooleanValue()));
        deserializerMap.put("location", n -> this.setLocation(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("start", n -> this.setStart((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((FreeBusyStatus)n.getEnumValue(FreeBusyStatus::forValue)));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsPrivate() {
        return (Boolean)this.backingStore.get("isPrivate");
    }

    @Nullable
    public String getLocation() {
        return (String)this.backingStore.get("location");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public DateTimeTimeZone getStart() {
        return (DateTimeTimeZone)this.backingStore.get("start");
    }

    @Nullable
    public FreeBusyStatus getStatus() {
        return (FreeBusyStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("end", (Parsable)this.getEnd(), new Parsable[0]);
        writer.writeBooleanValue("isPrivate", this.getIsPrivate());
        writer.writeStringValue("location", this.getLocation());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("start", (Parsable)this.getStart(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEnd(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("end", (Object)value);
    }

    public void setIsPrivate(@Nullable Boolean value) {
        this.backingStore.set("isPrivate", (Object)value);
    }

    public void setLocation(@Nullable String value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStart(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("start", (Object)value);
    }

    public void setStatus(@Nullable FreeBusyStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }
}

