/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.InsightIdentity;
import com.microsoft.graph.models.ResourceReference;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharingDetail
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SharingDetail() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SharingDetail createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharingDetail();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("sharedBy", n -> this.setSharedBy((InsightIdentity)n.getObjectValue(InsightIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("sharedDateTime", n -> this.setSharedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("sharingReference", n -> this.setSharingReference((ResourceReference)n.getObjectValue(ResourceReference::createFromDiscriminatorValue)));
        deserializerMap.put("sharingSubject", n -> this.setSharingSubject(n.getStringValue()));
        deserializerMap.put("sharingType", n -> this.setSharingType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public InsightIdentity getSharedBy() {
        return (InsightIdentity)this.backingStore.get("sharedBy");
    }

    @Nullable
    public OffsetDateTime getSharedDateTime() {
        return (OffsetDateTime)this.backingStore.get("sharedDateTime");
    }

    @Nullable
    public ResourceReference getSharingReference() {
        return (ResourceReference)this.backingStore.get("sharingReference");
    }

    @Nullable
    public String getSharingSubject() {
        return (String)this.backingStore.get("sharingSubject");
    }

    @Nullable
    public String getSharingType() {
        return (String)this.backingStore.get("sharingType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("sharedBy", (Parsable)this.getSharedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("sharedDateTime", this.getSharedDateTime());
        writer.writeStringValue("sharingSubject", this.getSharingSubject());
        writer.writeStringValue("sharingType", this.getSharingType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSharedBy(@Nullable InsightIdentity value) {
        this.backingStore.set("sharedBy", (Object)value);
    }

    public void setSharedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("sharedDateTime", (Object)value);
    }

    public void setSharingReference(@Nullable ResourceReference value) {
        this.backingStore.set("sharingReference", (Object)value);
    }

    public void setSharingSubject(@Nullable String value) {
        this.backingStore.set("sharingSubject", (Object)value);
    }

    public void setSharingType(@Nullable String value) {
        this.backingStore.set("sharingType", (Object)value);
    }
}

