/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAppConfiguration;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.graph.models.TargetedManagedAppPolicyAssignment;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TargetedManagedAppConfiguration
extends ManagedAppConfiguration
implements Parsable {
    public TargetedManagedAppConfiguration() {
        this.setOdataType("#microsoft.graph.targetedManagedAppConfiguration");
    }

    @Nonnull
    public static TargetedManagedAppConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TargetedManagedAppConfiguration();
    }

    @Nullable
    public List<ManagedMobileApp> getApps() {
        return (List)this.backingStore.get("apps");
    }

    @Nullable
    public List<TargetedManagedAppPolicyAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public Integer getDeployedAppCount() {
        return (Integer)this.backingStore.get("deployedAppCount");
    }

    @Nullable
    public ManagedAppPolicyDeploymentSummary getDeploymentSummary() {
        return (ManagedAppPolicyDeploymentSummary)this.backingStore.get("deploymentSummary");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("apps", n -> this.setApps(n.getCollectionOfObjectValues(ManagedMobileApp::createFromDiscriminatorValue)));
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(TargetedManagedAppPolicyAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("deployedAppCount", n -> this.setDeployedAppCount(n.getIntegerValue()));
        deserializerMap.put("deploymentSummary", n -> this.setDeploymentSummary((ManagedAppPolicyDeploymentSummary)n.getObjectValue(ManagedAppPolicyDeploymentSummary::createFromDiscriminatorValue)));
        deserializerMap.put("isAssigned", n -> this.setIsAssigned(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAssigned() {
        return (Boolean)this.backingStore.get("isAssigned");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("apps", this.getApps());
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeIntegerValue("deployedAppCount", this.getDeployedAppCount());
        writer.writeObjectValue("deploymentSummary", (Parsable)this.getDeploymentSummary(), new Parsable[0]);
        writer.writeBooleanValue("isAssigned", this.getIsAssigned());
    }

    public void setApps(@Nullable List<ManagedMobileApp> value) {
        this.backingStore.set("apps", value);
    }

    public void setAssignments(@Nullable List<TargetedManagedAppPolicyAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setDeployedAppCount(@Nullable Integer value) {
        this.backingStore.set("deployedAppCount", (Object)value);
    }

    public void setDeploymentSummary(@Nullable ManagedAppPolicyDeploymentSummary value) {
        this.backingStore.set("deploymentSummary", (Object)value);
    }

    public void setIsAssigned(@Nullable Boolean value) {
        this.backingStore.set("isAssigned", (Object)value);
    }
}

