/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeletedChat;
import com.microsoft.graph.models.DeletedTeam;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.TeamsAppSettings;
import com.microsoft.graph.models.WorkforceIntegration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Teamwork
extends Entity
implements Parsable {
    @Nonnull
    public static Teamwork createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Teamwork();
    }

    @Nullable
    public List<DeletedChat> getDeletedChats() {
        return (List)this.backingStore.get("deletedChats");
    }

    @Nullable
    public List<DeletedTeam> getDeletedTeams() {
        return (List)this.backingStore.get("deletedTeams");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deletedChats", n -> this.setDeletedChats(n.getCollectionOfObjectValues(DeletedChat::createFromDiscriminatorValue)));
        deserializerMap.put("deletedTeams", n -> this.setDeletedTeams(n.getCollectionOfObjectValues(DeletedTeam::createFromDiscriminatorValue)));
        deserializerMap.put("isTeamsEnabled", n -> this.setIsTeamsEnabled(n.getBooleanValue()));
        deserializerMap.put("region", n -> this.setRegion(n.getStringValue()));
        deserializerMap.put("teamsAppSettings", n -> this.setTeamsAppSettings((TeamsAppSettings)n.getObjectValue(TeamsAppSettings::createFromDiscriminatorValue)));
        deserializerMap.put("workforceIntegrations", n -> this.setWorkforceIntegrations(n.getCollectionOfObjectValues(WorkforceIntegration::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsTeamsEnabled() {
        return (Boolean)this.backingStore.get("isTeamsEnabled");
    }

    @Nullable
    public String getRegion() {
        return (String)this.backingStore.get("region");
    }

    @Nullable
    public TeamsAppSettings getTeamsAppSettings() {
        return (TeamsAppSettings)this.backingStore.get("teamsAppSettings");
    }

    @Nullable
    public List<WorkforceIntegration> getWorkforceIntegrations() {
        return (List)this.backingStore.get("workforceIntegrations");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("deletedChats", this.getDeletedChats());
        writer.writeCollectionOfObjectValues("deletedTeams", this.getDeletedTeams());
        writer.writeBooleanValue("isTeamsEnabled", this.getIsTeamsEnabled());
        writer.writeStringValue("region", this.getRegion());
        writer.writeObjectValue("teamsAppSettings", (Parsable)this.getTeamsAppSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("workforceIntegrations", this.getWorkforceIntegrations());
    }

    public void setDeletedChats(@Nullable List<DeletedChat> value) {
        this.backingStore.set("deletedChats", value);
    }

    public void setDeletedTeams(@Nullable List<DeletedTeam> value) {
        this.backingStore.set("deletedTeams", value);
    }

    public void setIsTeamsEnabled(@Nullable Boolean value) {
        this.backingStore.set("isTeamsEnabled", (Object)value);
    }

    public void setRegion(@Nullable String value) {
        this.backingStore.set("region", (Object)value);
    }

    public void setTeamsAppSettings(@Nullable TeamsAppSettings value) {
        this.backingStore.set("teamsAppSettings", (Object)value);
    }

    public void setWorkforceIntegrations(@Nullable List<WorkforceIntegration> value) {
        this.backingStore.set("workforceIntegrations", value);
    }
}

