/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyRuleTargetOperations;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UnifiedRoleManagementPolicyRuleTarget
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UnifiedRoleManagementPolicyRuleTarget() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UnifiedRoleManagementPolicyRuleTarget createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UnifiedRoleManagementPolicyRuleTarget();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCaller() {
        return (String)this.backingStore.get("caller");
    }

    @Nullable
    public List<String> getEnforcedSettings() {
        return (List)this.backingStore.get("enforcedSettings");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("caller", n -> this.setCaller(n.getStringValue()));
        deserializerMap.put("enforcedSettings", n -> this.setEnforcedSettings(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("inheritableSettings", n -> this.setInheritableSettings(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("level", n -> this.setLevel(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfEnumValues(UnifiedRoleManagementPolicyRuleTargetOperations::forValue)));
        deserializerMap.put("targetObjects", n -> this.setTargetObjects(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getInheritableSettings() {
        return (List)this.backingStore.get("inheritableSettings");
    }

    @Nullable
    public String getLevel() {
        return (String)this.backingStore.get("level");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<UnifiedRoleManagementPolicyRuleTargetOperations> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public List<DirectoryObject> getTargetObjects() {
        return (List)this.backingStore.get("targetObjects");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("caller", this.getCaller());
        writer.writeCollectionOfPrimitiveValues("enforcedSettings", this.getEnforcedSettings());
        writer.writeCollectionOfPrimitiveValues("inheritableSettings", this.getInheritableSettings());
        writer.writeStringValue("level", this.getLevel());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfEnumValues("operations", this.getOperations());
        writer.writeCollectionOfObjectValues("targetObjects", this.getTargetObjects());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCaller(@Nullable String value) {
        this.backingStore.set("caller", (Object)value);
    }

    public void setEnforcedSettings(@Nullable List<String> value) {
        this.backingStore.set("enforcedSettings", value);
    }

    public void setInheritableSettings(@Nullable List<String> value) {
        this.backingStore.set("inheritableSettings", value);
    }

    public void setLevel(@Nullable String value) {
        this.backingStore.set("level", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperations(@Nullable List<UnifiedRoleManagementPolicyRuleTargetOperations> value) {
        this.backingStore.set("operations", value);
    }

    public void setTargetObjects(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("targetObjects", value);
    }
}

