/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChangeTrackedEntity;
import com.microsoft.graph.models.WorkforceIntegrationEncryption;
import com.microsoft.graph.models.WorkforceIntegrationSupportedEntities;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WorkforceIntegration
extends ChangeTrackedEntity
implements Parsable {
    public WorkforceIntegration() {
        this.setOdataType("#microsoft.graph.workforceIntegration");
    }

    @Nonnull
    public static WorkforceIntegration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WorkforceIntegration();
    }

    @Nullable
    public Integer getApiVersion() {
        return (Integer)this.backingStore.get("apiVersion");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public WorkforceIntegrationEncryption getEncryption() {
        return (WorkforceIntegrationEncryption)this.backingStore.get("encryption");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("apiVersion", n -> this.setApiVersion(n.getIntegerValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("encryption", n -> this.setEncryption((WorkforceIntegrationEncryption)n.getObjectValue(WorkforceIntegrationEncryption::createFromDiscriminatorValue)));
        deserializerMap.put("isActive", n -> this.setIsActive(n.getBooleanValue()));
        deserializerMap.put("supportedEntities", n -> this.setSupportedEntities(n.getEnumSetValue(WorkforceIntegrationSupportedEntities::forValue)));
        deserializerMap.put("url", n -> this.setUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsActive() {
        return (Boolean)this.backingStore.get("isActive");
    }

    @Nullable
    public EnumSet<WorkforceIntegrationSupportedEntities> getSupportedEntities() {
        return (EnumSet)this.backingStore.get("supportedEntities");
    }

    @Nullable
    public String getUrl() {
        return (String)this.backingStore.get("url");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("apiVersion", this.getApiVersion());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("encryption", (Parsable)this.getEncryption(), new Parsable[0]);
        writer.writeBooleanValue("isActive", this.getIsActive());
        writer.writeEnumSetValue("supportedEntities", this.getSupportedEntities());
        writer.writeStringValue("url", this.getUrl());
    }

    public void setApiVersion(@Nullable Integer value) {
        this.backingStore.set("apiVersion", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEncryption(@Nullable WorkforceIntegrationEncryption value) {
        this.backingStore.set("encryption", (Object)value);
    }

    public void setIsActive(@Nullable Boolean value) {
        this.backingStore.set("isActive", (Object)value);
    }

    public void setSupportedEntities(@Nullable EnumSet<WorkforceIntegrationSupportedEntities> value) {
        this.backingStore.set("supportedEntities", value);
    }

    public void setUrl(@Nullable String value) {
        this.backingStore.set("url", (Object)value);
    }
}

