/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.externalconnectors;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.externalconnectors.ExternalActivityResult;
import com.microsoft.graph.models.externalconnectors.ExternalActivityType;
import com.microsoft.graph.models.externalconnectors.Identity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ExternalActivity
extends Entity
implements Parsable {
    @Nonnull
    public static ExternalActivity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.externalConnectors.externalActivityResult": {
                    return new ExternalActivityResult();
                }
            }
        }
        return new ExternalActivity();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("performedBy", n -> this.setPerformedBy((Identity)n.getObjectValue(Identity::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("type", n -> this.setType((ExternalActivityType)n.getEnumValue(ExternalActivityType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Identity getPerformedBy() {
        return (Identity)this.backingStore.get("performedBy");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public ExternalActivityType getType() {
        return (ExternalActivityType)((Object)this.backingStore.get("type"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("performedBy", (Parsable)this.getPerformedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("type", (Enum)this.getType());
    }

    public void setPerformedBy(@Nullable Identity value) {
        this.backingStore.set("performedBy", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setType(@Nullable ExternalActivityType value) {
        this.backingStore.set("type", (Object)value);
    }
}

