/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.externalconnectors;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.externalconnectors.ActivitySettings;
import com.microsoft.graph.models.externalconnectors.Configuration;
import com.microsoft.graph.models.externalconnectors.ConnectionOperation;
import com.microsoft.graph.models.externalconnectors.ConnectionState;
import com.microsoft.graph.models.externalconnectors.ExternalGroup;
import com.microsoft.graph.models.externalconnectors.ExternalItem;
import com.microsoft.graph.models.externalconnectors.Schema;
import com.microsoft.graph.models.externalconnectors.SearchSettings;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ExternalConnection
extends Entity
implements Parsable {
    @Nonnull
    public static ExternalConnection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ExternalConnection();
    }

    @Nullable
    public ActivitySettings getActivitySettings() {
        return (ActivitySettings)this.backingStore.get("activitySettings");
    }

    @Nullable
    public Configuration getConfiguration() {
        return (Configuration)this.backingStore.get("configuration");
    }

    @Nullable
    public String getConnectorId() {
        return (String)this.backingStore.get("connectorId");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activitySettings", n -> this.setActivitySettings((ActivitySettings)n.getObjectValue(ActivitySettings::createFromDiscriminatorValue)));
        deserializerMap.put("configuration", n -> this.setConfiguration((Configuration)n.getObjectValue(Configuration::createFromDiscriminatorValue)));
        deserializerMap.put("connectorId", n -> this.setConnectorId(n.getStringValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("groups", n -> this.setGroups(n.getCollectionOfObjectValues(ExternalGroup::createFromDiscriminatorValue)));
        deserializerMap.put("items", n -> this.setItems(n.getCollectionOfObjectValues(ExternalItem::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(ConnectionOperation::createFromDiscriminatorValue)));
        deserializerMap.put("schema", n -> this.setSchema((Schema)n.getObjectValue(Schema::createFromDiscriminatorValue)));
        deserializerMap.put("searchSettings", n -> this.setSearchSettings((SearchSettings)n.getObjectValue(SearchSettings::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((ConnectionState)n.getEnumValue(ConnectionState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<ExternalGroup> getGroups() {
        return (List)this.backingStore.get("groups");
    }

    @Nullable
    public List<ExternalItem> getItems() {
        return (List)this.backingStore.get("items");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public List<ConnectionOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public Schema getSchema() {
        return (Schema)this.backingStore.get("schema");
    }

    @Nullable
    public SearchSettings getSearchSettings() {
        return (SearchSettings)this.backingStore.get("searchSettings");
    }

    @Nullable
    public ConnectionState getState() {
        return (ConnectionState)((Object)this.backingStore.get("state"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("activitySettings", (Parsable)this.getActivitySettings(), new Parsable[0]);
        writer.writeObjectValue("configuration", (Parsable)this.getConfiguration(), new Parsable[0]);
        writer.writeStringValue("connectorId", this.getConnectorId());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfObjectValues("groups", this.getGroups());
        writer.writeCollectionOfObjectValues("items", this.getItems());
        writer.writeStringValue("name", this.getName());
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeObjectValue("schema", (Parsable)this.getSchema(), new Parsable[0]);
        writer.writeObjectValue("searchSettings", (Parsable)this.getSearchSettings(), new Parsable[0]);
    }

    public void setActivitySettings(@Nullable ActivitySettings value) {
        this.backingStore.set("activitySettings", (Object)value);
    }

    public void setConfiguration(@Nullable Configuration value) {
        this.backingStore.set("configuration", (Object)value);
    }

    public void setConnectorId(@Nullable String value) {
        this.backingStore.set("connectorId", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setGroups(@Nullable List<ExternalGroup> value) {
        this.backingStore.set("groups", value);
    }

    public void setItems(@Nullable List<ExternalItem> value) {
        this.backingStore.set("items", value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOperations(@Nullable List<ConnectionOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setSchema(@Nullable Schema value) {
        this.backingStore.set("schema", (Object)value);
    }

    public void setSearchSettings(@Nullable SearchSettings value) {
        this.backingStore.set("searchSettings", (Object)value);
    }

    public void setState(@Nullable ConnectionState value) {
        this.backingStore.set("state", (Object)value);
    }
}

