/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class HostPortBanner
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public HostPortBanner() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static HostPortBanner createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new HostPortBanner();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getBanner() {
        return (String)this.backingStore.get("banner");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("banner", n -> this.setBanner(n.getStringValue()));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("scanProtocol", n -> this.setScanProtocol(n.getStringValue()));
        deserializerMap.put("timesObserved", n -> this.setTimesObserved(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getScanProtocol() {
        return (String)this.backingStore.get("scanProtocol");
    }

    @Nullable
    public Integer getTimesObserved() {
        return (Integer)this.backingStore.get("timesObserved");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("banner", this.getBanner());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("scanProtocol", this.getScanProtocol());
        writer.writeIntegerValue("timesObserved", this.getTimesObserved());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBanner(@Nullable String value) {
        this.backingStore.set("banner", (Object)value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setScanProtocol(@Nullable String value) {
        this.backingStore.set("scanProtocol", (Object)value);
    }

    public void setTimesObserved(@Nullable Integer value) {
        this.backingStore.set("timesObserved", (Object)value);
    }
}

