/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.RecommendedAction;
import com.microsoft.graph.models.SimulationEventsContent;
import com.microsoft.graph.models.TrainingEventsContent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SimulationReportOverview
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SimulationReportOverview() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SimulationReportOverview createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SimulationReportOverview();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recommendedActions", n -> this.setRecommendedActions(n.getCollectionOfObjectValues(RecommendedAction::createFromDiscriminatorValue)));
        deserializerMap.put("resolvedTargetsCount", n -> this.setResolvedTargetsCount(n.getIntegerValue()));
        deserializerMap.put("simulationEventsContent", n -> this.setSimulationEventsContent((SimulationEventsContent)n.getObjectValue(SimulationEventsContent::createFromDiscriminatorValue)));
        deserializerMap.put("trainingEventsContent", n -> this.setTrainingEventsContent((TrainingEventsContent)n.getObjectValue(TrainingEventsContent::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<RecommendedAction> getRecommendedActions() {
        return (List)this.backingStore.get("recommendedActions");
    }

    @Nullable
    public Integer getResolvedTargetsCount() {
        return (Integer)this.backingStore.get("resolvedTargetsCount");
    }

    @Nullable
    public SimulationEventsContent getSimulationEventsContent() {
        return (SimulationEventsContent)this.backingStore.get("simulationEventsContent");
    }

    @Nullable
    public TrainingEventsContent getTrainingEventsContent() {
        return (TrainingEventsContent)this.backingStore.get("trainingEventsContent");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("recommendedActions", this.getRecommendedActions());
        writer.writeIntegerValue("resolvedTargetsCount", this.getResolvedTargetsCount());
        writer.writeObjectValue("simulationEventsContent", (Parsable)this.getSimulationEventsContent(), new Parsable[0]);
        writer.writeObjectValue("trainingEventsContent", (Parsable)this.getTrainingEventsContent(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecommendedActions(@Nullable List<RecommendedAction> value) {
        this.backingStore.set("recommendedActions", value);
    }

    public void setResolvedTargetsCount(@Nullable Integer value) {
        this.backingStore.set("resolvedTargetsCount", (Object)value);
    }

    public void setSimulationEventsContent(@Nullable SimulationEventsContent value) {
        this.backingStore.set("simulationEventsContent", (Object)value);
    }

    public void setTrainingEventsContent(@Nullable TrainingEventsContent value) {
        this.backingStore.set("trainingEventsContent", (Object)value);
    }
}

