/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.TrainingStatus;
import com.microsoft.graph.models.UserTrainingContentEventInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserTrainingEventInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserTrainingEventInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserTrainingEventInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserTrainingEventInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("latestTrainingStatus", n -> this.setLatestTrainingStatus((TrainingStatus)n.getEnumValue(TrainingStatus::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("trainingAssignedProperties", n -> this.setTrainingAssignedProperties((UserTrainingContentEventInfo)n.getObjectValue(UserTrainingContentEventInfo::createFromDiscriminatorValue)));
        deserializerMap.put("trainingCompletedProperties", n -> this.setTrainingCompletedProperties((UserTrainingContentEventInfo)n.getObjectValue(UserTrainingContentEventInfo::createFromDiscriminatorValue)));
        deserializerMap.put("trainingUpdatedProperties", n -> this.setTrainingUpdatedProperties((UserTrainingContentEventInfo)n.getObjectValue(UserTrainingContentEventInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public TrainingStatus getLatestTrainingStatus() {
        return (TrainingStatus)((Object)this.backingStore.get("latestTrainingStatus"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public UserTrainingContentEventInfo getTrainingAssignedProperties() {
        return (UserTrainingContentEventInfo)this.backingStore.get("trainingAssignedProperties");
    }

    @Nullable
    public UserTrainingContentEventInfo getTrainingCompletedProperties() {
        return (UserTrainingContentEventInfo)this.backingStore.get("trainingCompletedProperties");
    }

    @Nullable
    public UserTrainingContentEventInfo getTrainingUpdatedProperties() {
        return (UserTrainingContentEventInfo)this.backingStore.get("trainingUpdatedProperties");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("latestTrainingStatus", (Enum)this.getLatestTrainingStatus());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("trainingAssignedProperties", (Parsable)this.getTrainingAssignedProperties(), new Parsable[0]);
        writer.writeObjectValue("trainingCompletedProperties", (Parsable)this.getTrainingCompletedProperties(), new Parsable[0]);
        writer.writeObjectValue("trainingUpdatedProperties", (Parsable)this.getTrainingUpdatedProperties(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLatestTrainingStatus(@Nullable TrainingStatus value) {
        this.backingStore.set("latestTrainingStatus", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTrainingAssignedProperties(@Nullable UserTrainingContentEventInfo value) {
        this.backingStore.set("trainingAssignedProperties", (Object)value);
    }

    public void setTrainingCompletedProperties(@Nullable UserTrainingContentEventInfo value) {
        this.backingStore.set("trainingCompletedProperties", (Object)value);
    }

    public void setTrainingUpdatedProperties(@Nullable UserTrainingContentEventInfo value) {
        this.backingStore.set("trainingUpdatedProperties", (Object)value);
    }
}

