/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.deviceappmanagement.mobileapps;

import com.microsoft.graph.deviceappmanagement.mobileapps.count.CountRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphandroidlobapp.GraphAndroidLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphandroidstoreapp.GraphAndroidStoreAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphioslobapp.GraphIosLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphiosstoreapp.GraphIosStoreAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphiosvppapp.GraphIosVppAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmacosdmgapp.GraphMacOSDmgAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmacoslobapp.GraphMacOSLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmanagedandroidlobapp.GraphManagedAndroidLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmanagedioslobapp.GraphManagedIOSLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmanagedmobilelobapp.GraphManagedMobileLobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphmicrosoftstoreforbusinessapp.GraphMicrosoftStoreForBusinessAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphwin32lobapp.GraphWin32LobAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphwindowsappx.GraphWindowsAppXRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphwindowsmobilemsi.GraphWindowsMobileMSIRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphwindowsuniversalappx.GraphWindowsUniversalAppXRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.graphwindowswebapp.GraphWindowsWebAppRequestBuilder;
import com.microsoft.graph.deviceappmanagement.mobileapps.item.MobileAppItemRequestBuilder;
import com.microsoft.graph.models.MobileApp;
import com.microsoft.graph.models.MobileAppCollectionResponse;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MobileAppsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public CountRequestBuilder count() {
        return new CountRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphAndroidLobAppRequestBuilder graphAndroidLobApp() {
        return new GraphAndroidLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphAndroidStoreAppRequestBuilder graphAndroidStoreApp() {
        return new GraphAndroidStoreAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphIosLobAppRequestBuilder graphIosLobApp() {
        return new GraphIosLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphIosStoreAppRequestBuilder graphIosStoreApp() {
        return new GraphIosStoreAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphIosVppAppRequestBuilder graphIosVppApp() {
        return new GraphIosVppAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphMacOSDmgAppRequestBuilder graphMacOSDmgApp() {
        return new GraphMacOSDmgAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphMacOSLobAppRequestBuilder graphMacOSLobApp() {
        return new GraphMacOSLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphManagedAndroidLobAppRequestBuilder graphManagedAndroidLobApp() {
        return new GraphManagedAndroidLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphManagedIOSLobAppRequestBuilder graphManagedIOSLobApp() {
        return new GraphManagedIOSLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphManagedMobileLobAppRequestBuilder graphManagedMobileLobApp() {
        return new GraphManagedMobileLobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphMicrosoftStoreForBusinessAppRequestBuilder graphMicrosoftStoreForBusinessApp() {
        return new GraphMicrosoftStoreForBusinessAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphWin32LobAppRequestBuilder graphWin32LobApp() {
        return new GraphWin32LobAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphWindowsAppXRequestBuilder graphWindowsAppX() {
        return new GraphWindowsAppXRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphWindowsMobileMSIRequestBuilder graphWindowsMobileMSI() {
        return new GraphWindowsMobileMSIRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphWindowsUniversalAppXRequestBuilder graphWindowsUniversalAppX() {
        return new GraphWindowsUniversalAppXRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GraphWindowsWebAppRequestBuilder graphWindowsWebApp() {
        return new GraphWindowsWebAppRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MobileAppItemRequestBuilder byMobileAppId(@Nonnull String mobileAppId) {
        Objects.requireNonNull(mobileAppId);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("mobileApp%2Did", mobileAppId);
        return new MobileAppItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public MobileAppsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/deviceAppManagement/mobileApps{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}", pathParameters);
    }

    public MobileAppsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/deviceAppManagement/mobileApps{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}", rawUrl);
    }

    @Nullable
    public MobileAppCollectionResponse get() {
        return this.get(null);
    }

    @Nullable
    public MobileAppCollectionResponse get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (MobileAppCollectionResponse)this.requestAdapter.send(requestInfo, errorMapping, MobileAppCollectionResponse::createFromDiscriminatorValue);
    }

    @Nullable
    public MobileApp post(@Nonnull MobileApp body) {
        return this.post(body, null);
    }

    @Nullable
    public MobileApp post(@Nonnull MobileApp body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (MobileApp)this.requestAdapter.send(requestInfo, errorMapping, MobileApp::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull MobileApp body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull MobileApp body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, "{+baseurl}/deviceAppManagement/mobileApps", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public MobileAppsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new MobileAppsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Boolean count;
        @Nullable
        public String[] expand;
        @Nullable
        public String filter;
        @Nullable
        public String[] orderby;
        @Nullable
        public String search;
        @Nullable
        public String[] select;
        @Nullable
        public Integer skip;
        @Nullable
        public Integer top;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24count", this.count);
            allQueryParams.put("%24filter", this.filter);
            allQueryParams.put("%24search", this.search);
            allQueryParams.put("%24skip", this.skip);
            allQueryParams.put("%24top", this.top);
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24orderby", this.orderby);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

