/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.models.AuthenticationMethodTarget;
import com.microsoft.graph.models.Fido2KeyRestrictions;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Fido2AuthenticationMethodConfiguration
extends AuthenticationMethodConfiguration
implements Parsable {
    public Fido2AuthenticationMethodConfiguration() {
        this.setOdataType("#microsoft.graph.fido2AuthenticationMethodConfiguration");
    }

    @Nonnull
    public static Fido2AuthenticationMethodConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Fido2AuthenticationMethodConfiguration();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("includeTargets", n -> this.setIncludeTargets(n.getCollectionOfObjectValues(AuthenticationMethodTarget::createFromDiscriminatorValue)));
        deserializerMap.put("isAttestationEnforced", n -> this.setIsAttestationEnforced(n.getBooleanValue()));
        deserializerMap.put("isSelfServiceRegistrationAllowed", n -> this.setIsSelfServiceRegistrationAllowed(n.getBooleanValue()));
        deserializerMap.put("keyRestrictions", n -> this.setKeyRestrictions((Fido2KeyRestrictions)n.getObjectValue(Fido2KeyRestrictions::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<AuthenticationMethodTarget> getIncludeTargets() {
        return (List)this.backingStore.get("includeTargets");
    }

    @Nullable
    public Boolean getIsAttestationEnforced() {
        return (Boolean)this.backingStore.get("isAttestationEnforced");
    }

    @Nullable
    public Boolean getIsSelfServiceRegistrationAllowed() {
        return (Boolean)this.backingStore.get("isSelfServiceRegistrationAllowed");
    }

    @Nullable
    public Fido2KeyRestrictions getKeyRestrictions() {
        return (Fido2KeyRestrictions)this.backingStore.get("keyRestrictions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("includeTargets", this.getIncludeTargets());
        writer.writeBooleanValue("isAttestationEnforced", this.getIsAttestationEnforced());
        writer.writeBooleanValue("isSelfServiceRegistrationAllowed", this.getIsSelfServiceRegistrationAllowed());
        writer.writeObjectValue("keyRestrictions", (Parsable)this.getKeyRestrictions(), new Parsable[0]);
    }

    public void setIncludeTargets(@Nullable List<AuthenticationMethodTarget> value) {
        this.backingStore.set("includeTargets", value);
    }

    public void setIsAttestationEnforced(@Nullable Boolean value) {
        this.backingStore.set("isAttestationEnforced", (Object)value);
    }

    public void setIsSelfServiceRegistrationAllowed(@Nullable Boolean value) {
        this.backingStore.set("isSelfServiceRegistrationAllowed", (Object)value);
    }

    public void setKeyRestrictions(@Nullable Fido2KeyRestrictions value) {
        this.backingStore.set("keyRestrictions", (Object)value);
    }
}

