/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessReviewExpirationBehavior;
import com.microsoft.graph.models.EntitlementManagementSchedule;
import com.microsoft.graph.models.SubjectSet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageAssignmentReviewSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AccessPackageAssignmentReviewSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AccessPackageAssignmentReviewSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessPackageAssignmentReviewSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public AccessReviewExpirationBehavior getExpirationBehavior() {
        return (AccessReviewExpirationBehavior)((Object)this.backingStore.get("expirationBehavior"));
    }

    @Nullable
    public List<SubjectSet> getFallbackReviewers() {
        return (List)this.backingStore.get("fallbackReviewers");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("expirationBehavior", n -> this.setExpirationBehavior((AccessReviewExpirationBehavior)n.getEnumValue(AccessReviewExpirationBehavior::forValue)));
        deserializerMap.put("fallbackReviewers", n -> this.setFallbackReviewers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("isEnabled", n -> this.setIsEnabled(n.getBooleanValue()));
        deserializerMap.put("isRecommendationEnabled", n -> this.setIsRecommendationEnabled(n.getBooleanValue()));
        deserializerMap.put("isReviewerJustificationRequired", n -> this.setIsReviewerJustificationRequired(n.getBooleanValue()));
        deserializerMap.put("isSelfReview", n -> this.setIsSelfReview(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("primaryReviewers", n -> this.setPrimaryReviewers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("schedule", n -> this.setSchedule((EntitlementManagementSchedule)n.getObjectValue(EntitlementManagementSchedule::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsEnabled() {
        return (Boolean)this.backingStore.get("isEnabled");
    }

    @Nullable
    public Boolean getIsRecommendationEnabled() {
        return (Boolean)this.backingStore.get("isRecommendationEnabled");
    }

    @Nullable
    public Boolean getIsReviewerJustificationRequired() {
        return (Boolean)this.backingStore.get("isReviewerJustificationRequired");
    }

    @Nullable
    public Boolean getIsSelfReview() {
        return (Boolean)this.backingStore.get("isSelfReview");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<SubjectSet> getPrimaryReviewers() {
        return (List)this.backingStore.get("primaryReviewers");
    }

    @Nullable
    public EntitlementManagementSchedule getSchedule() {
        return (EntitlementManagementSchedule)this.backingStore.get("schedule");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("expirationBehavior", (Enum)this.getExpirationBehavior());
        writer.writeCollectionOfObjectValues("fallbackReviewers", this.getFallbackReviewers());
        writer.writeBooleanValue("isEnabled", this.getIsEnabled());
        writer.writeBooleanValue("isRecommendationEnabled", this.getIsRecommendationEnabled());
        writer.writeBooleanValue("isReviewerJustificationRequired", this.getIsReviewerJustificationRequired());
        writer.writeBooleanValue("isSelfReview", this.getIsSelfReview());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("primaryReviewers", this.getPrimaryReviewers());
        writer.writeObjectValue("schedule", (Parsable)this.getSchedule(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExpirationBehavior(@Nullable AccessReviewExpirationBehavior value) {
        this.backingStore.set("expirationBehavior", (Object)value);
    }

    public void setFallbackReviewers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("fallbackReviewers", value);
    }

    public void setIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEnabled", (Object)value);
    }

    public void setIsRecommendationEnabled(@Nullable Boolean value) {
        this.backingStore.set("isRecommendationEnabled", (Object)value);
    }

    public void setIsReviewerJustificationRequired(@Nullable Boolean value) {
        this.backingStore.set("isReviewerJustificationRequired", (Object)value);
    }

    public void setIsSelfReview(@Nullable Boolean value) {
        this.backingStore.set("isSelfReview", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrimaryReviewers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("primaryReviewers", value);
    }

    public void setSchedule(@Nullable EntitlementManagementSchedule value) {
        this.backingStore.set("schedule", (Object)value);
    }
}

