/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BaseItem;
import com.microsoft.graph.models.ContentTypeInfo;
import com.microsoft.graph.models.DocumentSetVersion;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.FieldValueSet;
import com.microsoft.graph.models.ItemAnalytics;
import com.microsoft.graph.models.ListItemVersion;
import com.microsoft.graph.models.SharepointIds;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ListItem
extends BaseItem
implements Parsable {
    public ListItem() {
        this.setOdataType("#microsoft.graph.listItem");
    }

    @Nonnull
    public static ListItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ListItem();
    }

    @Nullable
    public ItemAnalytics getAnalytics() {
        return (ItemAnalytics)this.backingStore.get("analytics");
    }

    @Nullable
    public ContentTypeInfo getContentType() {
        return (ContentTypeInfo)this.backingStore.get("contentType");
    }

    @Nullable
    public List<DocumentSetVersion> getDocumentSetVersions() {
        return (List)this.backingStore.get("documentSetVersions");
    }

    @Nullable
    public DriveItem getDriveItem() {
        return (DriveItem)this.backingStore.get("driveItem");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("analytics", n -> this.setAnalytics((ItemAnalytics)n.getObjectValue(ItemAnalytics::createFromDiscriminatorValue)));
        deserializerMap.put("contentType", n -> this.setContentType((ContentTypeInfo)n.getObjectValue(ContentTypeInfo::createFromDiscriminatorValue)));
        deserializerMap.put("documentSetVersions", n -> this.setDocumentSetVersions(n.getCollectionOfObjectValues(DocumentSetVersion::createFromDiscriminatorValue)));
        deserializerMap.put("driveItem", n -> this.setDriveItem((DriveItem)n.getObjectValue(DriveItem::createFromDiscriminatorValue)));
        deserializerMap.put("fields", n -> this.setFields((FieldValueSet)n.getObjectValue(FieldValueSet::createFromDiscriminatorValue)));
        deserializerMap.put("sharepointIds", n -> this.setSharepointIds((SharepointIds)n.getObjectValue(SharepointIds::createFromDiscriminatorValue)));
        deserializerMap.put("versions", n -> this.setVersions(n.getCollectionOfObjectValues(ListItemVersion::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public FieldValueSet getFields() {
        return (FieldValueSet)this.backingStore.get("fields");
    }

    @Nullable
    public SharepointIds getSharepointIds() {
        return (SharepointIds)this.backingStore.get("sharepointIds");
    }

    @Nullable
    public List<ListItemVersion> getVersions() {
        return (List)this.backingStore.get("versions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("analytics", (Parsable)this.getAnalytics(), new Parsable[0]);
        writer.writeObjectValue("contentType", (Parsable)this.getContentType(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("documentSetVersions", this.getDocumentSetVersions());
        writer.writeObjectValue("driveItem", (Parsable)this.getDriveItem(), new Parsable[0]);
        writer.writeObjectValue("fields", (Parsable)this.getFields(), new Parsable[0]);
        writer.writeObjectValue("sharepointIds", (Parsable)this.getSharepointIds(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("versions", this.getVersions());
    }

    public void setAnalytics(@Nullable ItemAnalytics value) {
        this.backingStore.set("analytics", (Object)value);
    }

    public void setContentType(@Nullable ContentTypeInfo value) {
        this.backingStore.set("contentType", (Object)value);
    }

    public void setDocumentSetVersions(@Nullable List<DocumentSetVersion> value) {
        this.backingStore.set("documentSetVersions", value);
    }

    public void setDriveItem(@Nullable DriveItem value) {
        this.backingStore.set("driveItem", (Object)value);
    }

    public void setFields(@Nullable FieldValueSet value) {
        this.backingStore.set("fields", (Object)value);
    }

    public void setSharepointIds(@Nullable SharepointIds value) {
        this.backingStore.set("sharepointIds", (Object)value);
    }

    public void setVersions(@Nullable List<ListItemVersion> value) {
        this.backingStore.set("versions", value);
    }
}

